/*
  unified_arc.c
  ------------------------------------------------------------------------
  Arc generation routines.
  ------------------------------------------------------------------------
  @(#) $Id: unified_arc.C,v 1.24 1998/05/29 22:27:29 emery Exp $
  ------------------------------------------------------------------------
  AUTHOR/CONTACT:

  Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
  Systems Analyst                 @           <mailto:emery@cs.utexas.edu>
  Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
  Department of Computer Sciences |             <http://www.cs.utexas.edu>
  University of Texas at Austin   |                <http://www.utexas.edu>
  ========================================================================
*/

#include <config.h>

#include <stream.h>
#include <unistd.h>
#include <misc/general.h>
#include <exmodel/abstree.h>
#include <exmodel/exmodel.h>
#include <symtab/symtab.h>
#include <lib/UidTable.h>
#include <lib/MsgUI.h>
#include <treebuild/pass.h>
#include <misc/voidlist.h>
#include <misc/sfile.h>
#include <misc/fileutil.h>
#include <lib/Syntax.h>
#include <symtab/symtab.h>

#include "unified_arc.h"
#include "unified_aux.h"


static void UnifiedNSConnect (cCursor & c, cArc * a)
{

  c << " /* Map NSRel to a processor. */ \n\n"
    << " int _c2_me = _c2_na->GetMachine().GetMessenger()->self();\n"
    << " _c2_TmpNSRel = (NameSharingRelation *) _c2_GetAddr(_c2_gr, " << a->ToUID << ", &_c2_ni, &_c2_na->GetMachine());\n"
    << " _c2_ValueType typetag;\n\n";

  switch (a->BaseType->IsA ()) {
  case IntSType:
    c << "typetag = _c2_IsAnInt;\n";
    break;
  case RealSType:
    c << "typetag = _c2_IsADouble;\n";
    break;
  case CharSType:
    c << "typetag = _c2_IsAChar;\n";
    break;
  case ArraySType:
    c << "typetag = _c2_IsAnArrayPtr;\n";
    break;
  case StructSType:
    c << "typetag = _c2_IsAStructPtr;\n";
    break;
  default:
    Die ("Internal error:  Illegal arc base type in UnifiedNSConnect\n");
  }

  c << " int i = _c2_TmpNSRel->Processor();\n";

  c << "if (i == _c2_me)\n"
    << "{\n"
    << "LocalNSLock * NewLock = new LocalNSLock (_c2_TmpNSRel, "
    << "(void *) &((_c2_nv" << a->ToUID << " *)(_c2_TmpNSRel->LocalData()->data()))->" << a->ToPort << ", "
    << "_c2_LocalReqType, "
    << "_c2_LocalAddr, "
    << a->ToUID << ", "
    << "typetag, "
    << "((_c2_nv" << a->ToUID << " *)(_c2_TmpNSRel->LocalData()->data()))->_c2_" << a->ToPort << "_SharedVarInfo);\n"
    << "_c2_na->GetLockSet().insert (NewLock);\n"
    << "}\n";

  c << "else\n"
    << "{\n"
    << "RemoteNSLock * NewLock = new RemoteNSLock ("
    << a->ToUID << ", "
    << "_c2_gr->GetPathName().str(), "
    << "_c2_ni, "
    << "_c2_LocalReqType, "
    << "_c2_LocalAddr, "
    << "typetag, "
    << "((_c2_nv" << a->ToUID << " *)(_c2_TmpNSRel->LocalData()->data()))->_c2_" << a->ToPort << "_SharedVarInfo);\n"
    << "_c2_na->GetLockSet().insert (NewLock);\n"
    << "}\n";

  if (AddDbgrCode) {
    c << "_c2_NewLock->psplist = \n"
      << "   &((_c2_nv" << a->ToUID << " *)(_c2_TmpNSRel->LocalData()->data()))"
      << "->_c2_" << a->ToPort << "_splist;\n\n";
  }
}


//Create code to Send data to a UC

static void UnifiedUCComm (cCursor & c, cArc * a)
{
  c << "_c2_TmpNode = (CompNode *) _c2_GetAddr(_c2_gr, " << a->ToUID << ", &_c2_ni, SerMach);\n"
    << "_c2_TmpValue = *_c2_value;\n"
    << "_c2_QVar = &((_c2_nv" << a->ToUID << " *)" << "(_c2_TmpNode->LocalData()->data()))->" << a->ToPort << ";\n";

  if (AddDbgrCode)
    c << "_c2_TmpValue.fplist = _c2_fplist;\n"
      << "_c2_TmpValue.cmd = _c2_cmd;\n";

  c << "_c2_TmpNode->AddToInputPort (*_c2_QVar, _c2_pi, _c2_TmpValue, SerMach);\n"
    << "_c2_TmpNode->Enqueue();\n";
}


//Create code to do an arc topo mapping

static void UnifiedArcMap (cCursor & c, cArc * a) {
  cVarDecl *v;
  cExpr *e;
  cObIterator i;
  int ic;
  cObject *p;

  c << "{\n";

  //Declare index variables

  for (p = i.Init (a->CallVarList); i.MoreLeft (); p = i.Next ()) {
    v = (cVarDecl *) p;
    c << "int " << v->VarName << ";\n";
  }

  for (p = i.Init (a->NodeVarList); i.MoreLeft (); p = i.Next ()) {
    v = (cVarDecl *) p;
    c << "int " << v->VarName << ";\n";
  }

  for (p = i.Init (a->PortVarList); i.MoreLeft (); p = i.Next ()) {
    v = (cVarDecl *) p;
    c << "int " << v->VarName << ";\n";
  }

  //Assign to index variables

  ic = 0;
  for (p = i.Init (a->CallVarList); i.MoreLeft (); p = i.Next ()) {
    v = (cVarDecl *) p;
    c << v->VarName << " = _c2_gi[" << ic << "];\n";
    ic += 1;
  }

  ic = 0;
  for (p = i.Init (a->NodeVarList); i.MoreLeft (); p = i.Next ()) {
    v = (cVarDecl *) p;
    c << v->VarName << " = _c2_ni[" << ic << "];\n";
    ic += 1;
  }

  ic = 0;
  for (p = i.Init (a->PortVarList); i.MoreLeft (); p = i.Next ()) {
    v = (cVarDecl *) p;
    c << v->VarName << " = (*_c2_pi)[" << ic << "];\n";
    ic += 1;
  }

  //Do the mapping

  ic = 0;
  for (p = i.Init (a->CallExprList); i.MoreLeft (); p = i.Next ()) {
    e = (cExpr *) p;
    c << "_c2_gi[" << ic << "] = ";
    c << e->Translate ();
    c << ";\n";
    ic += 1;
  }
  c << "_c2_gi.length() = " << ic << ";\n";

  ic = 0;
  for (p = i.Init (a->NodeExprList); i.MoreLeft (); p = i.Next ()) {
    e = (cExpr *) p;
    c << "_c2_ni[" << ic << "] = ";
    c << e->Translate ();
    c << ";\n";
    ic += 1;
  }
  c << "_c2_ni.length() = " << ic << ";\n";

  ic = 0;
  for (p = i.Init (a->PortExprList); i.MoreLeft (); p = i.Next ()) {
    e = (cExpr *) p;
    c << "(*_c2_pi)[" << ic << "] = ";
    c << e->Translate ();
    c << ";\n";
    ic += 1;
  }
  c << "(*_c2_pi).length() = " << ic << ";\n";

  c << "}\n";

}


//Create code to send to a crep

static void UnifiedCrep (cCursor & c, cCrepNode * cn, cGraph * GraphCalled, cArc * a) {

  c << "if (((_c2_gv" << GraphCalled->UID << " *) (_c2_gr->LocalData()->data()))"
    << "->_c2_" << cn->Name << " == 1) {\n"
    << "cout << \"The creation parameter " << cn->Name << " is already bound.\" << endl << flush;\n"
    << "// _c2_KillComp(_c2_CREPTWICE);\n"
    << "} // else \n"
    << "((_c2_gv" << GraphCalled->UID << " *) (_c2_gr->LocalData()->data()))"
    << "->_c2_" << cn->Name << " = 1;\n";

  c << "((_c2_gv" << GraphCalled->UID << " *) (_c2_gr->LocalData()->data()))"
    << "->" << cn->Name << " = (" << UnifiedGetName (cn->Type, cn)
    << ")_c2_value->u.";

  switch (a->BaseType->IsA ()) {
  case IntSType:
    c << "i";
    break;
  case RealSType:
    c << "d";
    break;
  case CharSType:
    c << "c";
    break;
  case ArraySType:
    c << "array";
    break;
  case StructSType:
    c << "structure";
    break;
  default:
    Die ("Internal error:  Illegal arc base type in UnifiedUCComm\n");
  }

  c << ";\n";

  if (AddDbgrCode) {
    c << "// _c2_InitWaitingNodes(_c2_TmpValue.fplist, _c2_gr);\n";
  }

  c << "_c2_gr->AddCrep ();\n";
}


//Create code for a call

static void UnifiedDoCall (cCursor & c, cArc * a, cAbsTree ** ToNode) {
  cGraph *CalledGraph;
  cCallNode *cn;
  cObIterator i;
  cObject *p;
  cSEGraph *GSym;
  cIntNode *in;
  ArcKind k;
  cCrepNode *crepnode;

  cn = (cCallNode *) *ToNode;
  GSym = (cSEGraph *) GetSymbol (cn->CalledGraph, a, SEGraph, 0);
  CalledGraph = GSym->Graph;

  c << "_c2_gr = (Graph *) _c2_GetAddr(_c2_gr, "
    << a->ToUID << ", &_c2_gi, SerMach);\n";

  //See if connects to an input interface node
  for (p = i.Init (CalledGraph->IntNodes); i.MoreLeft (); p = i.Next ()) {
    in = (cIntNode *) p;
    if ((char *) in->Name == a->ToPort) {
      FindArc (in->Name, in, &a, &k, ToNode);
      UnifiedDoNextArc (c, a, k, ToNode, c);
      return;
    }
  }

  //See if it connects to a CreP node
  for (p = i.Init (CalledGraph->CrepNodes); i.MoreLeft (); p = i.Next ()) {
    crepnode = (cCrepNode *) p;
    if ((char *) crepnode->Name == a->ToPort) {
      UnifiedCrep (c, crepnode, CalledGraph, a);
      return;
    }
  }
}



//Create code to call a port function pointer-- a return from a
// Graph

static void UnifiedCallPortFunc (cCursor & c, cArc * a) {
  cGraph *g;

  g = (cGraph *) a->Parent;

  c // << "}\n"
    << "{\n"
    << "Graph *_c2_TmpGraph;\n"
    << "_c2_TmpGraph = (Graph *) _c2_GetAddr(_c2_gr, _c2_PARENT, _c2_pi, &_c2_na->GetMachine());\n"
    << "_c2_gi = _c2_gr->MyIndex();\n";
  if (AddDbgrCode) {
    c << "(((_c2_gv" << g->UID << " *)(_c2_gr->LocalData()->data()))->_c2_prf"
      << a->ToUID << ")(_c2_TmpValue.fplist, _c2_TmpValue.cmd, "
      << "_c2_TmpGraph, _c2_gi, _c2_ni, _c2_pi, "
      << "&_c2_TmpNode, &_c2_QVar, _c2_value);\n";
  } else {
    c << "(((_c2_gv" << g->UID << " *)(_c2_gr->LocalData()->data()))->_c2_prf"
      << a->ToUID << ")(_c2_TmpGraph, _c2_na, _c2_gi, _c2_ni, _c2_pi, &_c2_TmpNode, "
      << "&_c2_QVar, _c2_value, _Messenger);\n";
  }
  c << "//  cout << \"Arc fired from \" << *_c2_na << endl;\n";
  c << "}\n";
}


//Create code to call NSRel port function pointer-- a return from a
// Graph

static void UnifiedCallNSPortFunc (cCursor & c, cArc * a) {
  cGraph *g;

  g = (cGraph *) a->Parent;

  c << "{\n"
    << "Graph *_c2_TmpGraph;\n"
    << "_c2_TmpGraph = (Graph *) _c2_GetAddr(_c2_gr, _c2_PARENT, _c2_pi, &_c2_na->GetMachine());\n"
    << "_c2_gi = _c2_gr->MyIndex();\n"
    << "(((_c2_gv" << g->UID << " *)(_c2_gr->LocalData()->data()))->_c2_prf"
    << a->ToUID << ")(_c2_TmpGraph, _c2_na, _c2_gi, _c2_ni, _c2_pi, _c2_na, _c2_LocalAddr, "
    << "_c2_LocalReqType, _c2_NewLock);\n"
    << "}\n";
}


//Create code for a UC to UC arc

static void UnifiedUC_UC (cCursor & c, cArc * a, cCursor & d) {
  UnifiedArcMap (c, a);
  UnifiedUCComm (d, a);
}


//Create code for a UC connected to a Call.

static void UnifiedUC_Call (cCursor & c, cArc * a, cAbsTree ** ToNode, cCursor & d) {
  UnifiedArcMap (c, a);
  UnifiedDoCall (d, a, ToNode);
}


static void UnifiedUC_OI (cCursor & c, cArc * a) {
  if (a->ConnectsNSRel)
    UnifiedCallNSPortFunc (c, a);
  else
    UnifiedCallPortFunc (c, a);
}

static void UnifiedUC_NS (cCursor & c, cArc * a) {
  UnifiedArcMap (c, a);
  UnifiedNSConnect (c, a);
}

static void UnifiedCall_Call (cCursor & c, cArc * a, cAbsTree ** ToNode, cCursor & d) {
  UnifiedArcMap (c, a);
  UnifiedDoCall (d, a, ToNode);
}

static void UnifiedCall_UC (cCursor & c, cArc * a, cCursor & d) {
  UnifiedArcMap (c, a);
  UnifiedUCComm (d, a);
}

static void UnifiedCall_OI (cCursor & c, cArc * a) {
  if (a->ConnectsNSRel)
    UnifiedCallNSPortFunc (c, a);
  else
    UnifiedCallPortFunc (c, a);
}

static void UnifiedCall_NS (cCursor & c, cArc * a) {
  UnifiedArcMap (c, a);
  UnifiedNSConnect (c, a);
}

static void UnifiedII_UC (cCursor & c, cArc * a, cCursor & d) {
  c = c; // eliminate compiler warning.
  UnifiedUCComm (d, a);
}

static void UnifiedII_Call (cCursor & c, cArc * a, cAbsTree ** ToNode, cCursor & d) {
  c = c;
  //eliminates compiler warning
  UnifiedDoCall (d, a, ToNode);
}

static void UnifiedII_OI (cCursor & c, cArc * a) {
  if (a->ConnectsNSRel)
    UnifiedCallNSPortFunc (c, a);
  else
    UnifiedCallPortFunc (c, a);
}

static void UnifiedII_NS (cCursor & c, cArc * a) {
  UnifiedNSConnect (c, a);
}


void UnifiedDoNextArc (cCursor & c, cArc * a, ArcKind kind, cAbsTree ** ToNode, cCursor & d) {
  switch (kind) {
  case kUC_UC:
    UnifiedUC_UC (c, a, d);
    break;
  case kUC_Call:
    UnifiedUC_Call (c, a, ToNode, d);
    break;
  case kUC_OI:
    UnifiedUC_OI (c, a);
    break;
  case kUC_NS:
    UnifiedUC_NS (c, a);
    break;
  case kCall_UC:
    UnifiedCall_UC (c, a, d);
    break;
  case kCall_Call:
    UnifiedCall_Call (c, a, ToNode, d);
    break;
  case kCall_OI:
    UnifiedCall_OI (c, a);
    break;
  case kCall_NS:
    UnifiedCall_NS (c, a);
    break;
  case kII_UC:
    UnifiedII_UC (c, a, d);
    break;
  case kII_Call:
    UnifiedII_Call (c, a, ToNode, d);
    break;
  case kII_OI:
    UnifiedII_OI (c, a);
    break;
  case kII_NS:
    UnifiedII_NS (c, a);
    break;
  default:
    Die ("Internal error: Bad kind in UnifiedDoNextArc.\n");
    break;
  }
}
