/*
  unified_aux.h
  ------------------------------------------------------------------------
  enum for sfile priorities.  There is an enum for each block type
  in the structured files.  The enums *must* appear in the correct
  order since the corresponding sub-blocks will be written in the
  same order.  See sfile.h.
  ------------------------------------------------------------------------
  @(#) $Id: unified_aux.h,v 1.7 1997/10/24 15:30:45 emery Exp $
  ------------------------------------------------------------------------
  AUTHOR/CONTACT:
 
  Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
  Systems Analyst                 @           <mailto:emery@cs.utexas.edu>
  Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
  Department of Computer Sciences |             <http://www.cs.utexas.edu>
  University of Texas at Austin   |                <http://www.utexas.edu>
  ========================================================================
*/

#ifndef _unified_aux_x
#define _unified_aux_x

#include <exmodel/exmodel.h>

enum {
 eRoot=1,
   eMakefile,
      eDecl,
      eObj,
      eProgt,
      eGrapht,
   eMain_h, 
      eGraphTypeDef,
      eGraphVar,  //[*]
      eNodeVar,  //[*]
      ePortFuncSig,
      eLocalPortFuncSig,
      eArcFuncSig,
      eLocalArcFuncSig,
      eNewFuncSig,
      eCopyFuncSig,
      eFreeFuncSig,
      eSharVarUIDFuncSig,
      eCopyNSRelSig,
      eMiscFuncSig,  // added for _c2_CopyUC, Graph; 7/23/96 EDB
   eMain_c,
      eGlobFunc,
      eNewFunc,
      eCopyFunc,
      eFreeFunc,
      eSharVarUIDFunc,
      eCopyNSRel,
        eCopyNSRelBody,
          eCopyNSRelAssign,
        eCopyNSRelBodyTail,
      eCopyNSRelTail,
      eGetSharedVarInfo,
        eGetSharedVarInfoBody,
      eGetSharedVarInfoTail,
      eIntFuncSig,
      eNameTableInit,  // Name table routines added by EDB, 5/29/96
      eNameTableEntry, //[*]
      eNameTableEnd,
      ePortFunctionsInit,  // A table of PortFunctions.
      ePortFunctions, // [*]
      ePortFunctionsEnd,
      eArcRouteFunctionsInit,  // A table of ArcRouteFunctions.
      eArcRouteFunctions, // [*]
      eArcRouteFunctionsEnd,
      eStaticTableInit,  // Static table routines added by EDB, 11/26/96
      eStaticTableEntry, //[*]
      eStaticTableEnd,
      eMesgHandler,
         eMHHead, 
         eMHMesgType1, //[*] by arc routine XX number
         eMHMesgTypeTail1,
         eMHMesgHead2,
         eMHMesgType2, //[*] by arc routine XX number
         eMHMesgTail2,
         eMHMesgHead3,
         eMHMesgType3, //[*] by NSRel UID 
          eMHMesgType3Body, //[*] by NSRel Identifier UID 
         eMHMesgType3BodyTail, 
         eMHMesgType3HeadMesg4, 
         eMHMesgType3Mesg4, 
          eMHMesgType3Mesg4Body, //[*] by NSRel Identifier UID
         eMHMesgType3Mesg4Tail, //[*] by NSRel UID
         eMHMesgTail3,
         eMHMesgHead4,
         eMHMesgType4, //[*] by NSRel UID
          eMHMesgType4Body, //[*] by NSRel Identifier UID 
         eMHMesgType4Tail, //[*] by NSRel UID 
         eMHMesgTail4,
         eMHMesgHead5,
         eMHMesgType5, //[*] by NSRel UID
          eMHMesgType5Body1, //[*] by NSRel Identifier UID 
          eMHMesgType5Body1Tail, //[*] by NSRel Identifier UID 
         eMHMesgType5Tail, //[*] by NSRel UID 
         eMHMesgType52,
          eMHMesgType5Body2, //[*] by NSRel Identifier UID 
          eMHMesgType5Body2Tail, //[*] by NSRel Identifier UID 
         eMHMesgType52Tail,
         eMHMesgTail5,
         eMHTail,
      eMakeObj,
         eMOHead,
         eMOEntry,  //[*]  // by graph or uc uid
	    eMOEntryCase,
            eMOEntryHead,
            eMOEntryInit,
            eMOEntryNSFini,
	    eMOEntrySWHead,
	    eMOEntrySWInit,  // [*] by call uid
               eMOEntrySWInCase,
               eMOEntrySWInBind,
               eMOEntrySWInTail,
            eMOEntryTail,
         eMOTail,
      eCopyArc,
         eCopyArcHead,
            eCopyArcCase,  // [*] by Arc uid
               eCopyArcCaseHead,
               eCopyArcCaseTail,
         eCopyArcTail,
      eCopyUC,           // CopyUC routines added by EDB, 7/12/96
         eCopyUCHead,
            eCopyUCCase,  // [*] by uc uid
               eCopyUCCaseHead,
               eCopyUCCase1Head,
                  eCopyUCCase1,  // [*] by var in uc
               eCopyUCCase1Tail,
               eCopyUCCase2Head,
                  eCopyUCCase2,  // [*] by var in uc
               eCopyUCCase2Tail,
               eCopyUCCaseTail,
         eCopyUCTail,
      eCopyGraph,        // CopyGraph routines added by EDB, 7/23/96
         eCopyGraphHead,
            eCopyGraphCase,  // [*] by Graph uid
               eCopyGraphCaseHead,
               eCopyGraphCase1Head,
                  eCopyGraphCase1,
               eCopyGraphCase1Tail,
               eCopyGraphCase2Head,
                  eCopyGraphCase2,
               eCopyGraphCase2Tail,
               eCopyGraphCaseTail,
         eCopyGraphTail,
      eMainProg,
      eDbgSymEntry,
	   eDbgSEHead,
	   eDbgSEBody,
	   eDbgSETail,
      eDbgSymAddr,
	   eSAHead,
	   eSAEntry,  //[*] by graph, nsrel, or uc uid
	       eSAEntryCase,
               eSAEntrySW,
	       eSAEntryTail,
	   eSATail,
   eGlob_h,
      eGlobTypeDef,
      eGlobFuncSig,
   eGraph_c,  //[*]
      eGraphFuncSig,
      eGraphFunc,
      ePortFunc, // [*] by arc UID
         ePortFuncHead,
         ePortFuncLocalBody,
         ePortFuncPvmMap,
         ePortFuncPvmBody,
         ePortFuncPvmSendType,
         ePortFuncTail,
      eLocalPortFunc, // [*] by arc UID
         eLocalPortFuncHead,
         eLocalPortFuncBody,
         eLocalPortFuncTail,
      eArcFunc,
         eArcFuncHead,
         eArcFuncLocalBody,
         eArcFuncPvmMap,
         eArcFuncPvmBody,
         eArcFuncPvmSendType,
         eArcFuncTail,
      eLocalArcFunc,
         eLocalArcFuncHead,
         eLocalArcFuncBody,
         eLocalArcFuncTail,
      eUCScope,  //[*]
         eUCFuncSig,
         eUCFunc,
         eUCIProc,
            eUCIProcHead,
            eUCIProcInit,
            eUCIProcComp,
            eUCIProcTail,
         eUCProc,
            eUCProcHead,
            eUCProcSharedVarAdd,
            eUCProcBefFrule,
            eUCProcFrule,  //[*] rule UID
	       eUCProcFRHead,
	       eUCProcFRCheck, // [*] guard or arc_in
	          eUCProcFRCheckHead,
	          eUCProcFRCheckBody,
	          eUCProcFRCheckTail,
               eUCProcFRNullCheck,
	       eUCProcFRBind,  // [*] arc_in or binding
		  eUCProcFRBindHead,
		  eUCProcFRBindBody,
		  eUCProcFRBindTail,
	       eUCProcFRTail,
            eUCProcComp,
            eUCProcRrule,  //[*] rule UID
	       eUCProcRRHead,
	       eUCProcRRCheck, // [*] guard
	          eUCProcRRCheckHead,
	          eUCProcRRCheckBody,
	          eUCProcRRCheckTail,
               eUCProcRRNullCheck,
	       eUCProcRRBind,  // [*] arc_out or binding
		  eUCProcRRBindHead,
		  eUCProcRRBindBody,
		  eUCProcRRBindTail,
	       eUCProcRRTail,
            eUCProcTail,
      eNSScope,  //[*]
         eNSFuncSig,
         eNSFunc,
         eNSIProc,
            eNSIProcHead,
            eNSIProcInit,
            eNSIProcComp,
            eNSIProcRelLock,
            eNSIProcTail
  };


  // Writes the structured files to disk, returns 1 for success else 0.
int UnifiedWriteFiles(cProgram *ProgramRoot);

  // Creates Makefile
void UnifiedMakefile(cProgram *p);

  // Creates the skeleton of MakeObj
void UnifiedMakeObj();

  // Creates main program in c2_main.c
void UnifiedCreateMain(cProgram *ProgramRoot);

  // UnifiedGetName returns the string that should be output to the
  // structured file.  It may not be the same as the ident since
  // some things have to be renamed.

MString UnifiedGetName(MString &Ident, cAbsTree *Here);

  // Write out user's unparsed functions.

void UnifiedDoFuncDefs(MString &FuncDefs, cAbsTree *Here);

  // Create procs to implement UC nodes

void UnifiedUCProc(cUC *u);

  // Create procs to implement NSRel nodes

void UnifiedNSProc(cNSRel *n);

  // Translates the UC MakeObj Entry

void UnifiedUCMakeObj(cUC *u);

  // Translates the Graph MakeObj Entry

void UnifiedGraphMakeObj(cGraph *g);

  // Translates the CSizeSpec objects in cVarDecl and cNewExpr

void UnifiedSizeSpec(cSizeSpec *SizeSpec, MString TypeName);

  // Create code to assign value from an arc to a local

void UnifiedArcAssign(cCursor &c, cExpr *VarExpr, cExpr *PortExpr,
		      cAbsTree *Here);

  // create function for an output port.

void UnifiedPortFunc(cPortSpec *p);

  // create function for UC shared var

void UnifiedSharVarFunc(cNSPortSpec *nsp, cSESharedVar *sv);


// Create all of the things needed for an arc route function.  These are
// created for all arcs that exit a Call node.

void UnifiedMakeArcRoute(cArc *a, cGraph *CalledGraph, cCallNode *cn);
void UnifiedMakeNSArcRoute(cArc *a, cGraph *CalledGraph, cCallNode *cn);

  // Create code for a ReplCond

void UnifiedCreateReplCond(cExpr *rc, cReplThing *Where);

void UnifiedGetSharedVarInfo (void);
void UnifiedCopyNSRel (void);
void UnifiedCopyArc (void);
void UnifiedCopyUC (void);
void UnifiedCopyGraph (void);

int UnifiedFillIndVar (cCursor&, MString, cExpr *, int);

#endif
