#include "c2_globtype.h"

void readsize(int *n, int *blk, int *printp, int *N)
{
  int numblks;
  printf("Enter the size of the block system: ");
  scanf("%d", N);

  printf("Enter the size of a block (integer): ");
  scanf("%d", blk);

  *n = (*N) * (*blk);

  printf("Print all (0 or 1): ");
  scanf("%d", printp);
}

  /* Allocate and obtain values for a and b */

void readsys(int N, int blk, Matrix a, BlockVect b)
{
   int n = N * blk;
   real c = 1.0;
   int i, j;
   Vector tmp_a, tmp_b;

   for (i = 0; i < n; i++) {
      tmp_a = a[i];
      for (j = 0; j <= i; j++)
        tmp_a[j] = 1.0;
   }

   for (i = 0; i < N; i++) {
      tmp_b = b[i];
      for (j = 0; j < blk; j++) {
         tmp_b[j] = c;
         c += 1.0;
      }
   }

}

  /* Solve a block */

void solveblock(int WhichBlock, Matrix a, Vector b, int blk)
{
  int offset = WhichBlock*blk;
  double sum;
  Vector tmp;
  int i, j;

  for (i = 0; i < blk; i++) {
     sum = b[i];
     tmp = a[i+offset];
     for (j = 0; j < i; j++)
       sum = sum - tmp[j+offset]*b[j];
     b[i] = sum / tmp[i+offset];
  }
}


   /* Do matrix vector multiply for a block */

void blkmult(int NodeIndex, Matrix a, Vector b_left, Vector b_up, int WhichCol, int blk)
{
   int row_offset = NodeIndex * blk;
   int col_offset = WhichCol * blk;
   double sum;
   Vector tmp;
   int i, j;

   for (i = 0; i < blk; i++) {
      sum = b_left[i];
      tmp = a[i+row_offset];
      for (j = 0; j < blk; j++)
        sum = sum - tmp[j+col_offset]*b_up[j];
      b_left[i] = sum;
   }
}


   /* print b */

void printans(int N, int blk, BlockVect b, int printp)
{
   int i, j, c = 0;

   if (printp == 0) {
      printf("x[%d] = %f\n", 0, b[0][0]);
   } else
      for (i = 0; i < N; i++)
         for (j = 0; j < blk; j++) {
            printf("x[%d] = %f\n", c, b[i][j]);
            c += 1;
         }

}

