/* Block Triangular solver - Sequential C.  Uses CODE array rep  */

/*  Build with cc -fast -o seq seq.c */

#include <stdio.h>

typedef double real;
typedef double *Vector;
typedef Vector *Matrix;

#include <stdio.h>
#include <limits.h>
#include <sys/times.h>
#include <time.h>

static float c2_SysSec;
static float c2_UserSec;
static clock_t start_time;
static clock_t end_time;


void StartClock() {
  struct tms before;

  start_time  = times(&before);

  c2_SysSec  = (float)before.tms_stime/(float)CLK_TCK;
  c2_UserSec = (float)before.tms_utime/(float)CLK_TCK;

}

void StopClock() {
  struct tms after;

  end_time    = times(&after);

  c2_SysSec  = (float)after.tms_stime/(float)CLK_TCK - c2_SysSec;
  c2_UserSec = (float)after.tms_utime/(float)CLK_TCK - c2_UserSec;
}


/* Signal a halt to the computation */

void StopAll()
{


  printf("Time between completion of node and firing of node:\n");
  printf("  Wall clock time = %f seconds.\n",(float)(end_time - start_time)/(float)CLK_TCK);
  printf("  System time: %f seconds.\n", c2_SysSec);
  printf("  User time  : %f seconds.\n", c2_UserSec);

  fflush(stdout);
  fflush(stderr);
}



  /* prompt for user input */

void readsize(n, blk, printp)
  int *n;
  int *blk;
  int *printp;
{
  int numblks;

  printf("Enter the size of the block system: ");
  scanf("%d", &numblks);

  printf("Enter the size of a block (integer): ");
  scanf("%d", blk);

  *n = numblks*(*blk);
   
  printf("Print all (0 or 1): ");
  scanf("%d", printp);
}

  /* Allocate space for b */

Vector MakeB(n)
   int n;
{
   return (Vector) malloc(n*sizeof(real));
}

  /* Allocate space for A */

Matrix MakeA(n)
   int n;
{
   Matrix t;
   int i;

   t = (Matrix) malloc(n*sizeof(Vector));

   for (i = 0; i < n; i++)
      t[i] = (Vector) malloc((i+1)*sizeof(real));

   return t;
}

  /* Allocare and obtain values for a and b */

void readsys(n, a, b)
   int n;
   Matrix a;
   Vector b;
{
   int i, j;
   Vector tmp;

   for (i = 0; i < n; i++) {
      b[i] = i + 1.0;
      tmp = a[i];
      for (j = 0; j <= i; j++)
        tmp[j] = 1.0;
   }
}


   /* print b */

void printans(n, b, printp)
   int n;
   Vector b;
   int printp;
{
   int start, stop;
   int i;

   if (printp == 0) {
      start = n/2;
      stop = start;
   } else {
      start = 0;
      stop = n - 1;
   }

   for (i = start; i <= stop; i++)
     printf("x[%d] = %f\n", i, b[i]);
}



void solve(n, a, x)
   int n;
   Matrix a;
   Vector x;
{
   double sum;
   Vector tmp;
   int i;
   int j;

   for (i = 0; i < n; i++) {
      sum = x[i];
      tmp = a[i];
      for (j = 0; j < i; j++)
	sum = sum - tmp[j]*x[j];
      x[i] = sum / tmp[i];
   }
}

main ()
{  
   Vector x;
   Matrix a;
   int n;
   int dummy;
   int printp;


   readsize(&n, &dummy, &printp);
   x = MakeB(n);
   a = MakeA(n);
   readsys(n, a, x);
   StartClock();
   solve(n, a, x);
   printans(n, x, printp);
   StopClock();
   StopAll();
}
