/*
  abstree.c
  ------------------------------------------------------------------------
  
  ------------------------------------------------------------------------
  @(#) $Id: abstree.C,v 1.12 1997/07/03 19:20:12 emery Exp $
  ------------------------------------------------------------------------
  AUTHOR/CONTACT:
 
  Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
  Systems Analyst                 @           <mailto:emery@cs.utexas.edu>
  Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
  Department of Computer Sciences |             <http://www.cs.utexas.edu>
  University of Texas at Austin   |                <http://www.utexas.edu>
  ========================================================================
*/

#include <config.h>
#include <stream.h>

// CODE includes
#include <misc/general.h>
#include <exmodel/classid.h>
#include <exmodel/object.h>
#include "abstree.h"
#include <lib/UidTable.h>

  // If a parse error occurs, these variables tell where (parser.h)
extern int yycolumn;       // column of error
extern int yylinenum;      // line number of error

static int NewUID = -2;    // Frontend uses positives; backend negatives.

// Whenever a cAbsTree object is created, it is placed in a table
// called a UidTable that allows mapping from Uid's to objects.
// This table is also used to free storage for all objects in the
// AST.  Note that this implies that all AST objects must be allocated
// on the heap.


cAbsTree::cAbsTree()
{
   Parent = 0;
   SymbolTable = 0;
   UID = NewUID--;
   ErrLine = yylinenum;
   ErrCol = yycolumn;

   InsertUidTable(this);

#ifdef DEBUG
   cout << "cAbsTree instance created\n";
#endif
}

  // FreeSymTab is defined in symtab.h.  This little hack sidesteps a #include
  // problem.  FreeSymTab simply deletes SymbolTabe

void FreeSymTab(cSymTab *SymbolTable);

cAbsTree::~cAbsTree()
{
   FreeSymTab(SymbolTable);
}
