/*
  abstree.h
  ------------------------------------------------------------------------
    
  ------------------------------------------------------------------------
  @(#) $Id: abstree.h,v 1.18 1997/12/17 21:08:25 emery Exp $
  ------------------------------------------------------------------------
  AUTHOR/CONTACT:
 
  Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
  Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
  Department of Computer Sciences |             <http://www.cs.utexas.edu>
  University of Texas at Austin   |                <http://www.utexas.edu>
  ========================================================================
*/

#ifndef _abstree_x
#define _abstree_x

#include <stddef.h>
#include "exmodel/object.h"
#include "exmodel/classid.h"

class cSymTab;

class cAbsTree : public cObject {
 public:                         // virtuals must be overridden.

   cAbsTree();                   // Constructor adds instance to thread.
   virtual ~cAbsTree();          // Lets ALL destructors be runtime chosen

   cAbsTree *Parent;             // Pointer to parent in tree
   cSymTab *SymbolTable;         // Pointer to symbols at this scope.

   int UID;                      // Universal ID

   int ErrLine;
   int ErrCol;

   // If any of these are called, it means
   // that somewhere a method has not been implemented.

   virtual void Pass1() {Die("Base Pass1 Called"); };
   virtual void Optim1() {Die("Base Optim1 Called"); };
   virtual void MakeSTEntry(cSymTab *SymTab) 
     {Die("Base MakeSTEntry Called"); SymTab = SymTab;};
   virtual void Pass2() {Die("Base Pass2 Called"); };
   virtual void Pass3() {Die("Base Pass2 Called"); };
   virtual void TreeWalk() {Die("Base TreeWalk Called"); };
   virtual void Mpi() { Unified(); };
   virtual void Serial() {Die("Base Serial Called"); };
   virtual void Unified() {Die("Base Unified Called"); };
};

#endif

