/*
  arc.c
  ------------------------------------------------------------------------
  This file contains methods for arc-related abstract syntax
  tree classes.
  ------------------------------------------------------------------------
  @(#) $Id: arc.C,v 1.8 1996/08/27 19:26:47 emery Exp $
  ------------------------------------------------------------------------
  AUTHOR/CONTACT:
 
  Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
  Systems Analyst                 @           <mailto:emery@cs.utexas.edu>
  Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
  Department of Computer Sciences |             <http://www.cs.utexas.edu>
  University of Texas at Austin   |                <http://www.utexas.edu>
  ========================================================================
*/

#include <config.h>

#include <stddef.h>
#include <stream.h>
#include "../misc/general.h"
#include "classid.h"
#include "object.h"
#include "abstree.h"
#include "exmodel.h"
#include "../symtab/symtab.h"

  // Arc topology specs.

cArc::cArc()
{
   ConnectsNSRel = 0;                     // Set to 1 if needed in pass3
   if (DebugLevel >= 7) {
      cout << "cArc instance created\n";
   }
}


cArc::~cArc()
{
   if (DebugLevel >= 7) {
      cout << "cArc instance destroyed\n";
   }
}


  // List vars on LHS of arc topo rule.

static void ListArcVarList(cObList &L)
{
   cObIterator i;
   cObject *p;

   for (p = i.Init(L); i.MoreLeft(); p = i.Next()) {
      cout << "[";
      cout << ((cVarDecl *) p)->VarName;
      cout << "]";
   }
}


  // List expressions on RHS of arc topo rule.

static void ListArcExprList(cObList &L)
{
   cObIterator i;
   cObject *p;

   for (p = i.Init(L); i.MoreLeft(); p = i.Next()) {
      cout << "[";
      p->List();
      cout << "]";
   }
}


void cArc::List()
{
   cout << "arc " << Name << " <" << UID << "> {\n";

   //if (SymbolTable != 0) SymbolTable->List();

   cout << "ArcType = " << ArcType << "\n";

   switch (ArcType) {
    case 1:
      cout << "Port: ";
      cout << FromPort;
      break;
    case 2:
      ListArcVarList(NodeVarList);
      cout << ".";
      cout << FromPort;
      ListArcVarList(PortVarList);
      cout << " => ";
      ListArcExprList(NodeExprList);
      cout << ".";
      cout << ToPort;
      ListArcExprList(PortExprList);
      break;
    case 3:
      ListArcVarList(NodeVarList);
      cout << ".";
      cout << FromPort;
      ListArcVarList(PortVarList);
      cout << " => ";
      ListArcExprList(CallExprList);
      cout << ".";
      ListArcExprList(NodeExprList);
      cout << ".";
      cout << ToPort;
      ListArcExprList(PortExprList);
      break;
    case 4:
      ListArcVarList(CallVarList);
      cout << ".";
      ListArcVarList(NodeVarList);
      cout << ".";
      cout << FromPort;
      ListArcVarList(PortVarList);
      cout << " => ";
      ListArcExprList(NodeExprList);
      cout << ".";
      cout << ToPort;
      ListArcExprList(PortExprList);
      break;
    case 5:
      ListArcVarList(CallVarList);
      cout << ".";
      ListArcVarList(NodeVarList);
      cout << ".";
      cout << FromPort;
      ListArcVarList(PortVarList);
      cout << " => ";
      ListArcExprList(CallExprList);
      cout << ".";
      ListArcExprList(NodeExprList);
      cout << ".";
      cout << ToPort;
      ListArcExprList(PortExprList);
      break;
    case 6:
      break;
   }

   cout << "\n}\n\n";

}
