#include <config.h>
// This file contains methods for function signature related abstract syntax
// tree classes.

#include <stddef.h>
#include <stream.h>
#include "../misc/general.h"
#include "classid.h"
#include "object.h"
#include "abstree.h"
#include "exmodel.h"

cFuncArgSpec::cFuncArgSpec(char *InitTypeName, char *InitArgName, int Ref)
{
   TypeName = InitTypeName;
   ArgName = InitArgName;
   Reference = Ref;

   if (DebugLevel >= 7) {
      cout << "cFuncArgSpec created\n";
   }
}


cFuncArgSpec::~cFuncArgSpec()
{

   if (DebugLevel >= 7) {
      cout << "cFuncArgSpec created\n";
   }
}


void cFuncArgSpec::List()
{
   cout << TypeName << " ";
   if (Reference) cout << "*";
   cout << ArgName;
}


cFuncSig::cFuncSig(char *InitFuncName, char *InitReturnType,
		   cObList &InitArgs)
{
   FuncName = InitFuncName;
   ReturnType = InitReturnType;
   DontCheckArgs = 0;
   Args = InitArgs;

   if (DebugLevel >= 7) {
      cout << "cFuncSig instance created\n";
   }
}


cFuncSig::cFuncSig(char *InitFuncName, char *InitReturnType)
{
   FuncName = InitFuncName;
   ReturnType = InitReturnType;
   DontCheckArgs = 0;

   if (DebugLevel >= 7) {
      cout << "cFuncSig instance created\n";
   }
}


cFuncSig::cFuncSig(char *InitFuncName, cObList &InitArgs)
{
   FuncName = InitFuncName;
   DontCheckArgs = 0;
   Args = InitArgs;

   if (DebugLevel >= 7) {
      cout << "cFuncSig instance created\n";
   }
}


cFuncSig::cFuncSig(char *InitFuncName)
{
   FuncName = InitFuncName;
   DontCheckArgs = 0;

   if (DebugLevel >= 7) {
      cout << "cFuncSig instance created\n";
   }
}


cFuncSig::~cFuncSig()
{
   if (DebugLevel >= 7) {
      cout << "cFuncSig instance destroyed\n";
   }
}


void cFuncSig::List()
{
   cObIterator i;
   cObject *p;
   int FirstOne = 1;

   cout << ReturnType << " " << FuncName << "(";

   if (DontCheckArgs) {
      cout << "...";
   } else {
      for (p=i.Init(Args); i.MoreLeft(); p=i.Next()) {
	 if (FirstOne)
	   FirstOne = 0;
	 else
	   cout << ", ";
	 p->List();
      }
   }

  cout << ");\n";

}
