#include <config.h>
// This file contains methods for non-UC node related
// abstract syntax tree classes.

#include <stddef.h>
#include <stream.h>
#include "../misc/general.h"
#include "classid.h"
#include "object.h"
#include "abstree.h"
#include "exmodel.h"
#include "../symtab/symtab.h"

cGraph::cGraph()
{
   if (DebugLevel >= 7) {
      cout << "cGraph created\n";
   }
}


cGraph::~cGraph()
{
}


void cGraph::List()
{
   cObIterator i;
   cObject *p;

   cout << "graph " << Name << " <" << UID << "> {\n";

   //if (SymbolTable != 0) SymbolTable->List();

   cout << "types {\n";
   for (p = i.Init(Types); i.MoreLeft(); p = i.Next())
     p->List();
   cout << "}\n";

   cout << "Function_Signatures {\n";
   for (p = i.Init(FuncSigs); i.MoreLeft(); p = i.Next())
     p->List();
   cout << "}\n";

   for (p = i.Init(IntNodes); i.MoreLeft(); p = i.Next())
     p->List();

   for (p = i.Init(CrepNodes); i.MoreLeft(); p = i.Next())
     p->List();

   for (p = i.Init(UCNodes); i.MoreLeft(); p = i.Next())
     p->List();

   for (p = i.Init(CallNodes); i.MoreLeft(); p = i.Next())
     p->List();

   for (p = i.Init(NSRelNodes); i.MoreLeft(); p = i.Next())
     p->List();

   for (p = i.Init(Arcs); i.MoreLeft(); p = i.Next())
     p->List();

   cout << "}\n\n";

}
