#include <config.h>
// This file contains methods for name sharing relation-related
// abstract syntax tree classes.

#include <stddef.h>
#include <stream.h>
#include "../misc/general.h"
#include "classid.h"
#include "object.h"
#include "abstree.h"
#include "exmodel.h"
#include "../symtab/symtab.h"

cNSRel::cNSRel(cObList &InitSharedVars, cObList &InitLocalVars,
	       cStmt *InitInitComp)
{
   SharedVars = InitSharedVars;
   LocalVars = InitLocalVars;
   InitComp = InitInitComp;

   if (DebugLevel >= 7) {
      cout << "cNSRel created\n";
   }
}


cNSRel::~cNSRel()
{
   if (DebugLevel >= 7) {
      cout << "cNSRel destroyed\n";
   }
}


void cNSRel::List()
{
   cObIterator i;
   cObject *p;

   cout << "shared_var {\n";

   //if (SymbolTable != 0) SymbolTable->List();

   for (p = i.Init(SharedVars); i.MoreLeft(); p = i.Next())
     p->List();
   cout << "}\n";

   cout << "var {\n";
   for (p = i.Init(LocalVars); i.MoreLeft(); p = i.Next())
     p->List();
   cout << "}\n";

   cout << "init_comp\n";
   if (InitComp != 0) InitComp->List();
}
