#include <config.h>
#include "../misc/general.h"
#include "../exmodel/classid.h"
#include "object.h"


cObject::~cObject()
{
}
 

// Basic list manipulation classes

cObList::~cObList()
{
   this->Destroy();
}

cObject *cObList::First()
{
   if (this->Empty())
     Die("\nError: attempt to access first elmt of empty list\n");

   return Start->Val;
}


cObject *cObList::Last()
{
   if (this->Empty())
      Die("\nError: attempt to access last elmt of empty list\n");

   return End->Val;
}


cObject *cObList::Nth(int n)
{
   int i;
   cObLink *pt;

   if (n >= Count)
      Die("\nError: attempt to access Nth elmt out of range\n");

   pt = Start;
   for (i=0; i<n; i++) pt = pt->Next;
   return pt->Val;
}


// add item to the front of the list

void cObList::Insert (cObject *Val)
{
   cObLink *pt = new cObLink(Val);

   if (Start == 0) End = pt;
   pt->Next = Start;
   Start = pt;
   Count += 1;
}


// add item to end of the list

void cObList::Append(cObject *Val)
{
   cObLink *pt = new cObLink(Val);

   pt->Next = 0;
   if (Start == 0)
      Start = pt;
   else
      End->Next = pt;
   End = pt;
   Count += 1;
}


// Remove items that are eq in the Lisp sense to the argument.  eq
// means "points to the same object". Return NumDeleted.

int cObList::RemEq(cObject *Val)
{
   int NumDeleted = 0, Len, i;
   cObLink *pt, *pt_prev, *tmp;

   Len = Count;
   pt = Start;
   pt_prev = 0;
   for (i=0; i< Len; i++)
     if (pt->Val == Val) {     // delete this one
	if (pt == Start) Start = pt->Next;
	if (pt == End) End = pt_prev;
	if (pt_prev != 0) pt_prev->Next = pt->Next;
	tmp = pt;
	pt = pt->Next;
	NumDeleted += 1;
        Count -= 1;
	delete tmp;
     }
     else {
	pt_prev = pt;
        pt = pt->Next;
     }
   
   return NumDeleted;
}


cObject *cObList::PopFirst()
{
   cObLink *tmp;
   cObject *Val;

   if (Start == 0)
      Die("\nError: attempt to PopFirst from empty list\n");

   tmp = Start;
   if (End == Start) End = 0;
   Start = Start->Next;
   Val = tmp->Val;
   delete tmp;
   Count -= 1;

   return Val;
}
   
cObject *cObList::PopLast()
{
   cObLink *NextToLast, *tmp;
   cObject *Val;

   if (Start == 0)
      Die("\nError: attempt to PopLast from empty list\n");

   tmp = Start;
   NextToLast = 0;
   while (tmp->Next != 0) {
      NextToLast = tmp;
      tmp = tmp->Next;
   }

   tmp = End;
   if (Start == End)
     Start = 0;
   else
     NextToLast->Next = 0;
   End = NextToLast;
   Val = tmp->Val;
   delete tmp;
   Count -= 1;

   return Val;
}


void cObList::Map (cObjectFuncPtr pf)
{
   cObLink *pt;

   pt = Start;
   while (pt != 0) {
      pf(pt->Val);
      pt = pt->Next;
   }
}


void cObList::Destroy()
{
   cObLink *pt, *tmp;

   pt = Start;
   while (pt != 0) {
      tmp = pt;
      pt = pt->Next;
      delete tmp;
   }
   Start = 0;
   End = 0;
   Count = 0;
}


void cObList::ConCat(cObList &L)
{
   // Add L's members to list
   if (Start == 0) {
      Start =  L.Start;
      End = L.End;
      Count = L.Count;
   } else {
      End->Next = L.Start;
      End = L.End;
      Count += L.Count;
   }

   // Make L the empty List
   L.Start = 0;
   L.End = 0;
   L.Count = 0;

}


void cObList::SetEmpty()
{
   Start = 0;
   End = 0;
   Count = 0;
}


cObject *cObIterator::Init(cObList &x)
{
   if (x.Start == 0) {
      Current = 0;
      return 0;
   }
   Current = x.Start;
   return Current->Val;
}


cObject *cObIterator::Next()
{

   Current = Current->Next;
   if (Current == 0) {
      return 0;
   }
   return Current->Val;
}


// delete node pointed to by p-- useful with Map()

void DeleteNode(cObject *p)
{
   delete p;
}
