#include <config.h>
// This file contains methods for non-UC node related
// abstract syntax tree classes.

#include <stddef.h>
#include <stream.h>
#include "../misc/general.h"
#include "classid.h"
#include "object.h"
#include "abstree.h"
#include "exmodel.h"
#include "../symtab/symtab.h"

cProgram::cProgram()
{
   if (DebugLevel >= 7) {
      cout << "cProgram created\n";
   }
}


cProgram::~cProgram()
{
}


void cProgram::List()
{
   cObIterator i;
   cObject *p;

   cout << "program " << Name << " <" << UID << "> {\n";

   //if (SymbolTable != 0) SymbolTable->List();

   cout << "types {\n";
   for (p = i.Init(Types); i.MoreLeft(); p = i.Next())
     p->List();
   cout << "}\n";

   cout << "Function_Signatures {\n";
   for (p = i.Init(FuncSigs); i.MoreLeft(); p = i.Next())
     p->List();
   cout << "}\n";

   cout << "Graphs {\n";
   for (p = i.Init(Graphs); i.MoreLeft(); p = i.Next())
     p->List();
   cout << "}\n";

   cout << "}\n";

}
