#include <config.h>
// Example and test program for the abstree package
//
//  Invents its own derived classes but requires that Program and Graph
//  be ClassIds.

#include <stddef.h>
#include <stream.h>
#include "../misc/general.h"
#include "classid.h"
#include "object.h"
#include "abstree.h"
#include "exmodel.h"

class cProgram : public cAbsTree {
 public:
   cProgram(int j) { i = j; }
   int i;
   ClassId IsA() { return Program; }
   void PrintId() { cout << "Program\n"; }
   void List () {};
};

class cGraph : public cAbsTree {
 public:
   cGraph(int j) { k = j; }
   int k;
   ClassId IsA() { return Graph; }
   void PrintId() { cout << "Graph\n"; }
   void List () {};
};


static void foo(cObject *t)
{
   if (t->IsA() == Program)
     cout << "Program number " << ((cProgram *) t) -> i << "\n";
   else if (t->IsA() == Graph)
     cout << "Graph number " << ((cGraph *) t) -> k << "\n";
}


main ()
{
   cProgram *p;
   cGraph *g;
   cObject *tmp1, *tmp2;
   cObList L1;
   cObIterator I, J;
   int i;

   if (L1.Empty()) cout << "List starts empty\n";

   p = new cProgram(1);
   L1.Insert(p);
   g = new cGraph(2);
   L1.Append(g);

   cout << "Length is " << L1.Length() << "\n";
   cout << "First is "; L1.First()->PrintId();
   cout << "Last is "; L1.Last()->PrintId();

   // Call PrintId for each element
   for (i=0; i<L1.Length(); i++) {
     L1.Nth(i)->PrintId();   
   }

   for (tmp1=I.Init(L1); I.MoreLeft(); tmp1=I.Next())
     for (tmp2=J.Init(L1); J.MoreLeft(); tmp2=J.Next()) {
	tmp1->PrintId();
	tmp2->PrintId();
	cout << "****\n";
     }

   L1.Map(foo);

   (void) L1.PopFirst();
   (void) L1.PopLast();
   
   if (L1.Empty()) cout << "List ends empty\n";

   p = new cProgram(1);
   L1.Insert(p);
   g = new cGraph(2);
   L1.Append(g);

   L1.Destroy();
   if (L1.Empty()) cout << "List still empty\n";

   // Note that storage for the cPrograms and cGraphs is NOT freed.

}
