/*
  types.C
  ------------------------------------------------------------------------
  This file contains methods for type-related abstract syntax
  tree classes.
  
  ------------------------------------------------------------------------
  @(#) $Id: types.C,v 1.5 1996/08/27 19:26:58 emery Exp $
  ------------------------------------------------------------------------
  AUTHOR/CONTACT:
 
  Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
  Systems Analyst                 @           <mailto:emery@cs.utexas.edu>
  Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
  Department of Computer Sciences |             <http://www.cs.utexas.edu>
  University of Texas at Austin   |                <http://www.utexas.edu>
  ========================================================================
*/

#include <config.h>

#include <stddef.h>
#include <stream.h>
#include "misc/general.h"
#include "classid.h"
#include "object.h"
#include "abstree.h"
#include "exmodel.h"
 
cNamedType::cNamedType(char *InitTypeName)
{

   TypeName = InitTypeName;

   if (DebugLevel >= 7) {
      cout << "cNamedType created\n";
   }
}


cNamedType::~cNamedType()
{
   if (DebugLevel >= 7) {
      cout << "cNamedType destroyed\n";
   }
}


void cNamedType::List()
{
   cout << TypeName;
}


cStructMem::cStructMem(char *InitType, char *InitName)
{
   Type = InitType;
   Name = InitName;

   if (DebugLevel >= 7) {
      cout << "cStructMem created\n";
   }
}


cStructMem::~cStructMem()
{
   if (DebugLevel >= 7) {
      cout << "cStructMem destroyed\n";
   }
}


void cStructMem::List()
{
   cout << Type << " " << Name << ";\n";
}


cStructType::cStructType(cObList &L)
{
   Members = L;

   if (DebugLevel >= 7) {
      cout << "cStructType created\n";
   }
}


cStructType::~cStructType()
{
   if (DebugLevel >= 7) {
      cout << "cStructType destroyed\n";
   }
}


void cStructType::List()
{
   cObIterator i;
   cObject *p;

   cout << "struct {\n";
   for (p = i.Init(Members); i.MoreLeft(); p = i.Next())
     p->List();
   cout << "}";
}


cArrayType::cArrayType(char *InitBaseType)
{
   BaseType = InitBaseType;

   if (DebugLevel >= 7) {
      cout << "cArrayType created\n";
   }
}


cArrayType::~cArrayType()
{
   if (DebugLevel >= 7) {
      cout << "cArrayType destroyed\n";
   }
}


void cArrayType::List()
{
   cout << "array of " <<  BaseType;
}


cTypeDef::cTypeDef (char *InitName, cAbsTree *InitType)
{
   Name = InitName;
   Type = InitType;

   if (DebugLevel >= 7) {
      cout << "cTypeDef instance created\n";
   }
}


cTypeDef::~cTypeDef ()
{
   if (DebugLevel >= 7) {
      cout << "cTypeDef instance destroyed\n";
   }
}

void cTypeDef::List ()
{
   cout << "type " << Name << " is ";
   Type->List();
   cout << ";\n";

   if (DebugLevel >= 7) {
      cout << "cTypeDef instance created\n";
   }
}
