#include <config.h>
// This file contains methods for UC node related
// abstract syntax tree classes.

#include <stddef.h>
#include <stream.h>
#include "../misc/general.h"
#include "classid.h"
#include "object.h"
#include "abstree.h"
#include "exmodel.h"
#include "../symtab/symtab.h"

cReplSpec::cReplSpec(char *InitIndVar, cExpr *InitBound)
{
   IndVar = InitIndVar;
   Bound = InitBound;

   if (DebugLevel >= 7) {
      cout << "cReplSpec created\n";
   }
}


cReplSpec::~cReplSpec()
{
   if (DebugLevel >= 7) {
      cout << "cReplSpec destroyed\n";
   }
}


void cReplSpec::List()
{
   if (Bound == 0) Die("Null Bound in cReplSpec\n");

   cout << "(";
   cout << IndVar << " ";
   Bound->List();
   cout << ")";
}


cGuard::cGuard(cExpr *InitCond)
{
   Cond = InitCond;
   ReplCond = 0;

   if (DebugLevel >= 7) {
      cout << "cGuard created\n";
   }
}


cGuard::~cGuard()
{

   if (DebugLevel >= 7) {
      cout << "cGuard destroyed\n";
   }
}


void cGuard::List()
{
   cObIterator i;
   cObject *p;

   if (!Repls.Empty()) cout << "{";

   if (Cond == 0) Die("Null Cond in Guard\n");
   Cond->List();

   if (!Repls.Empty()) cout << " : ";

   for (p = i.Init(Repls); i.MoreLeft(); p = i.Next())
     p->List();

   if (!Repls.Empty() && ReplCond != 0) {
      cout << "; ";
      ReplCond->List();
   }

   if (!Repls.Empty()) cout << " } ";
}


cArcInput::cArcInput(cExpr *InitPortExpr, cExpr *InitVarExpr)
{
   PortExpr = InitPortExpr;
   VarExpr = InitVarExpr;
   ReplCond = 0;

   if (DebugLevel >= 7) {
      cout << "cArcInput created\n";
   }
}


cArcInput::~cArcInput()
{
   if (DebugLevel >= 7) {
      cout << "cArcInput destroyed\n";
   }
}


void cArcInput::List()
{
   cObIterator i;
   cObject *p;

   if (!Repls.Empty()) cout << "{";

   if (PortExpr == 0) Die("Null PortExpr in ArcInput\n");
   PortExpr->List();

   cout << " -> ";

   if (VarExpr == 0) Die("Null VarExpr in ArcInput\n");
   VarExpr->List();

   if (!Repls.Empty()) cout << " : ";
   

   for (p = i.Init(Repls); i.MoreLeft(); p = i.Next())
     p->List();

   if (!Repls.Empty() && ReplCond != 0) {
      cout << "; ";
      ReplCond->List();
   }

   if (!Repls.Empty()) cout << " }";
}


cBinding::cBinding(cAssignStmt *InitBind)
{
   Bind = InitBind;
   ReplCond = 0;

   if (DebugLevel >= 7) {
      cout << "cBinding created\n";
   }
}


cBinding::~cBinding()
{
   if (DebugLevel >= 7) {
      cout << "cBinding destroyed\n";
   }
}


void cBinding::List()
{
   cObIterator i;
   cObject *p;

   if (!Repls.Empty()) cout << "{";

   if (Bind == 0) Die("Null Bind in Binding\n");
   Bind->List();

   if (!Repls.Empty()) cout << " : ";
   

   for (p = i.Init(Repls); i.MoreLeft(); p = i.Next())
     p->List();

   if (!Repls.Empty() && ReplCond != 0) {
      cout << "; ";
      ReplCond->List();
   }

   if (!Repls.Empty()) cout << " }";

}


cArcOutput::cArcOutput(cExpr *InitPortExpr, cExpr *InitValueExpr)
{
   PortExpr = InitPortExpr;
   ValueExpr = InitValueExpr;
   ReplCond = 0;

   if (DebugLevel >= 7) {
      cout << "cArcOutput created\n";
   }
}


cArcOutput::~cArcOutput()
{
   if (DebugLevel >= 7) {
      cout << "cArcOutput destroyed\n";
   }
}


void cArcOutput::List()
{
   cObIterator i;
   cObject *p;

   if (!Repls.Empty()) cout << "{";

   if (PortExpr == 0) Die("Null PortExpr in ArcInput\n");
   PortExpr->List();

   cout << " <- ";

   if (ValueExpr == 0) Die("Null ValueExpr in ArcOutput\n");
   ValueExpr->List();

   if (!Repls.Empty()) cout << " : ";
   

   for (p = i.Init(Repls); i.MoreLeft(); p = i.Next())
     p->List();

   if (!Repls.Empty() && ReplCond != 0) {
      cout << "; ";
      ReplCond->List();
   }

   if (!Repls.Empty()) cout << " }";
}


cRule::cRule(cObList &InitGuards, cObList &InitBinds)
{
   Guards = InitGuards;
   Binds = InitBinds;
   ReplCond = 0;

   if (DebugLevel >= 7) {
      cout << "cRule created\n";
   }
}


cRule::~cRule()
{
   if (DebugLevel >= 7) {
      cout << "cRule destroyed\n";
   }
}


void cRule::List()
{
   cObIterator i;
   cObject *tmp;
   int FirstInList = 1;

   if (!Repls.Empty()) cout << "{";

   for (tmp = i.Init(Guards); i.MoreLeft(); tmp = i.Next()) {
      if (FirstInList) FirstInList = 0;
      else cout << ", ";
      tmp->List();
   }

   cout << " => ";

   for (tmp = i.Init(Binds); i.MoreLeft(); tmp = i.Next()) 
      tmp->List();

   if (!Repls.Empty()) cout << " : ";

   for (tmp = i.Init(Repls); i.MoreLeft(); tmp = i.Next())
     tmp->List();

   if (!Repls.Empty() && ReplCond != 0) {
      cout << "; ";
      ReplCond->List();
   }

   if (!Repls.Empty()) cout << " }";
}


cPortSpec::cPortSpec(char *InitTypeName, char *InitPortName)
{
   TypeName = InitTypeName;
   PortName = InitPortName;

   if (DebugLevel >= 7) {
      cout << "cPortSpec created\n";
   }
}


cPortSpec::~cPortSpec()
{

   if (DebugLevel >= 7) {
      cout << "cPortSpec destroyed\n";
   }
}


void cPortSpec::List()
{
   cout << TypeName << " " << PortName << ";\n";
}


cNSPortSpec::cNSPortSpec(NSClass InitUseRule)
{
   UseRule = InitUseRule;

   if (DebugLevel >= 7) {
      cout << "cNSPortSpec created\n";
   }
}


cNSPortSpec::~cNSPortSpec()
{
   if (DebugLevel >= 7) {
      cout << "cNSPortSpec destroyed\n";
   }
}


void cNSPortSpec::List()
{
   cout << TypeName << " " << PortName;
   if (UseRule == NSReader) cout << " Reader;\n";
   else cout << " Writer;\n";
}


cUC::cUC()
{
   TermNode = 0;
   StartNode = 0;

   if (DebugLevel >= 7) {
      cout << "cUC created\n";
   }
}


cUC::~cUC()
{
   if (DebugLevel >= 7) {
      cout << "cUC destroyed\n";
   }
}


void cUC::List()
{
   cObIterator i, j;
   cObject *p, *q;
   cRule *r;
   cGuard *g;
   cBinding *b;

   cout << "uc " << Name << " <" << UID << "> {\n";

   //if (SymbolTable != 0) SymbolTable->List();

   //cout << "input rule symbol tables {\n";

   for (p = i.Init(InRules); i.MoreLeft(); p = i.Next()) {

      r = (cRule *) p;
      //if (r->SymbolTable != 0) r->SymbolTable->List();

      for (q = j.Init(r->Guards); j.MoreLeft(); q = j.Next()) {
	 g = (cGuard *) q;
	 //if (g->SymbolTable != 0) g->SymbolTable->List();
      }

      for (q = j.Init(r->Binds); j.MoreLeft(); q = j.Next()) {
	 b = (cBinding *) q;
	 //if (b->SymbolTable != 0) b->SymbolTable->List();
      }
   }
   //cout << "}\n";

   //cout << "output rule symbol tables {\n";

   for (p = i.Init(OutRules); i.MoreLeft(); p = i.Next()) {

      r = (cRule *) p;
      //if (r->SymbolTable != 0) r->SymbolTable->List();

      for (q = j.Init(r->Guards); j.MoreLeft(); q = j.Next()) {
	 g = (cGuard *) q;
	 //if (g->SymbolTable != 0) g->SymbolTable->List();
      }

      for (q = j.Init(r->Binds); j.MoreLeft(); q = j.Next()) {
	 b = (cBinding *) q;
	 //if (b->SymbolTable != 0) b->SymbolTable->List();
      }
   }
   //cout << "}\n";

   cout << "Is Terminate Node = " << TermNode << "\n";
   cout << "Is Start Node = " << StartNode << "\n";

   cout << "function_signatures {\n";
   for (p = i.Init(FuncSigs); i.MoreLeft(); p = i.Next())
     p->List();
   cout << "}\n";

   cout << "input_ports {\n";
   for (p = i.Init(InputPorts); i.MoreLeft(); p = i.Next())
     p->List();
   cout << "}\n";

   cout << "output_ports {\n";
   for (p = i.Init(OutputPorts); i.MoreLeft(); p = i.Next())
     p->List();
   cout << "}\n";

   cout << "shared_var {\n";
   for (p = i.Init(NSPorts); i.MoreLeft(); p = i.Next())
     p->List();
   cout << "}\n";

   cout << "var {\n";
   for (p = i.Init(LocalVars); i.MoreLeft(); p = i.Next())
     p->List();
   cout << "}\n";

   if (InitComp != 0) {
      cout << "init_comp\n";
      InitComp->List();
   }

   cout << "input_rules {\n";
   for (p = i.Init(InRules); i.MoreLeft(); p = i.Next())
     p->List();
   cout << "}\n";

   if (Comp != 0) {
      cout << "comp\n";
      Comp->List();
   }

   cout << "output_rules {\n";
   for (p = i.Init(OutRules); i.MoreLeft(); p = i.Next())
     p->List();
   cout << "}\n\n";

}
