#include <config.h>
#include <stdarg.h>
#include <stddef.h>
#include <stream.h>
#include <misc/general.h>
#include "classid.h"
#include "object.h"
#include "abstree.h"
#include "exmodel.h"
#include <lib/MsgUI.h>

  // Starting at "Here" in the AST return the first instance of type
  // given by ClassType up the tree.  The ... args must be of type
  // ClassId and the list must be ended with a 0.

  //   example: (void) GetContaining(this, UC, NSRel, 0);


cAbsTree *GetContaining(cAbsTree *Here, ...)
{
   va_list ap;
   ClassId c1, c2;

   while (Here != 0) {

      c1 = Here->IsA();
      va_start(ap, Here);

      while ((c2 = va_arg(ap, ClassId)) != 0) {

	 if (c1 == c2) {
	    va_end(ap);
	    return Here;
	 }
      }

      va_end(ap);
      Here = Here->Parent;

   }

   Die("** Internal error:  Containing class not found");

   return 0;  // quiets a compiler warning...
}


  // Like GetContaining but returns 0 in case of failure.

cAbsTree *CheckContaining(cAbsTree *Here, ...)
{
   va_list ap;
   ClassId c1, c2;

   while (Here != 0) {

      c1 = Here->IsA();
      va_start(ap, Here);

      while ((c2 = va_arg(ap, ClassId)) != 0) 
	if (c1 == c2) {
	   va_end(ap);
	   return Here;
	}

      va_end(ap);
      Here = Here->Parent;

   }

   return 0;

}

