#include <config.h>
#include <stdio.h>
#include <stdarg.h>

#include <tcl.h>

extern Tcl_Interp *main_interp;
extern int C2_ErrorUID;

#include <misc/general.h>
#include <exmodel/exmodel.h>
#include <parser/parser.h>

#include "MsgUI.h"
#include "UidTable.h"


FILE *ErrorLogFile;  // Output file for error messages.

typedef struct msglog {
    int uid;
    MsgLevel level;
    char *msg;
    struct msglog *next;
} MsgLog, *pMsgLog;


#define pNullLog ((pMsgLog)0)
pMsgLog pFirstMsg = pNullLog;
pMsgLog pLastMsg = pNullLog;

// Accept a message to be displayed to the user and buffer it for when
// YYUIMessageDisplay is called.

void YYUIMessage(int uid, MsgLevel Level, char *format_string, ...)
{
   va_list arg_pointer;
   pMsgLog pThisMsg = new MsgLog;
   static char GreatBigOString[1024];
   char *InsertionPt;
   static char *LevelStr[] = {"FATAL", "ERROR", "WARNING", "NOTE"};

   // For now, we just dump to stderr (in YYUIMessageDisplay.)  
   // Better to have a popup window.

   InsertionPt = GreatBigOString;

   // sprintf(InsertionPt, "*** %s *** (UID %d): %s \n", LevelStr[Level], GetContainingUid(uid), PathUidTable(uid));
   sprintf(InsertionPt, "%s: ", LevelStr[Level]);
   InsertionPt = GreatBigOString + strlen(GreatBigOString);
   // InsertionPt += sprintf(...) is ANSI only

   // Save the erroneous uid for the user interface to lookup.
   C2_ErrorUID = GetContainingUid(uid);

   cAbsTree *ErrAbsTree = FindUidTable(uid);
   if (ErrAbsTree != ((cAbsTree *)0) ) { // syntax error deal with un-parent-ed AST
     // sprintf(InsertionPt, "   at line %d column %d \n", ErrAbsTree->ErrLine, ErrAbsTree->ErrCol); 
     // InsertionPt = GreatBigOString + strlen(GreatBigOString);  
     yylinenum = ErrAbsTree->ErrLine;
     yycolumn = ErrAbsTree->ErrCol;
   }

   va_start(arg_pointer, format_string);
   vsprintf(InsertionPt, format_string, arg_pointer);
   va_end(arg_pointer);


   // creates a new entry in the error log linked list
   pThisMsg->uid = uid;
   pThisMsg->level = Level;
   pThisMsg->msg = new char[strlen(GreatBigOString)+1];
   strcpy(pThisMsg->msg, GreatBigOString);

   // adds new entry to the tail of the list
   if (pLastMsg != pNullLog) {
       pLastMsg->next =  pThisMsg;
       pLastMsg = pThisMsg;
   } else {
       pFirstMsg = pLastMsg = pThisMsg;
   }
   pThisMsg->next = pNullLog;
}

void YYUIMessage(MsgLevel Level, char *format_string, ...)
{
   va_list arg_pointer;
   pMsgLog pThisMsg = new MsgLog;
   static char GreatBigOString[1024];
   char *InsertionPt;
   static char *LevelStr[] = {"FATAL", "ERROR", "WARNING", "NOTE"};

   // For now, we just dump to stderr (in YYUIMessageDisplay.)  
   // Better to have a popup window.

   InsertionPt = GreatBigOString;

   sprintf(InsertionPt, "*** %s *** \n", LevelStr[Level]);
   InsertionPt = GreatBigOString + strlen(GreatBigOString);  
   // InsertionPt += sprintf(...) is ANSI only

   va_start(arg_pointer, format_string);
   vsprintf(InsertionPt, format_string, arg_pointer);
   va_end(arg_pointer);

   // creates a new entry in the error log linked list
   pThisMsg->uid = 0;
   pThisMsg->level = Level;
   pThisMsg->msg = new char[strlen(GreatBigOString)+1];
   strcpy(pThisMsg->msg, GreatBigOString);

   // adds new entry to the tail of the list
   if (pLastMsg != pNullLog) {
       pLastMsg->next =  pThisMsg;
       pLastMsg = pThisMsg;
   } else {
       pFirstMsg = pLastMsg = pThisMsg;
   }
   pThisMsg->next = pNullLog;
}

void YYUIMessageDisplay()
{
  pMsgLog pThisMsg, pNextMsg;
  char *string;

  pThisMsg =  pFirstMsg; 
  while (pThisMsg != pNullLog) {
    fprintf(ErrorLogFile, "%s\n", pThisMsg->msg) ;

    pNextMsg = pThisMsg->next;
    delete pThisMsg->msg;
    delete pThisMsg;
    pThisMsg = pNextMsg;
  }
  pFirstMsg = pLastMsg = pNullLog;

  fflush(stderr);
}

