/*
 code2.C
 ------------------------------------------------------------------------
 The main program -- starts up the GUI, connecting to it the translation
 procedures.
 ------------------------------------------------------------------------
 @(#) $Id: code2.C,v 1.24 1997/11/25 17:56:21 emery Exp $
 ------------------------------------------------------------------------
 AUTHOR/CONTACT:
 
 Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
 Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
 Department of Computer Sciences |             <http://www.cs.utexas.edu>
 University of Texas at Austin   |                <http://www.utexas.edu>
 ========================================================================
*/


#include <config.h>
#include <stream.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>

#include <misc/mstring.h>
#include <misc/fileutil.h>

#include <misc/general.h>
#include <exmodel/abstree.h>
#include <exmodel/exmodel.h>
#include <parser/parser.h>

#include <tcl.h>
// #include <expect_tcl.h>
#include <tk.h>
#include <itcl.h>
#include <itk.h>
#include <tix.h>

#include "massage.h"
#include "astcreate.h"
#include "utils.h"

static char const rcsid[] = "$Id: code2.C,v 1.24 1997/11/25 17:56:21 emery Exp $";

int C2_ErrorUID;		// Stores the UID of an erroneous object.
void Die(char *Message);	// Print Message, clean up, and quit.

#include <misc/sfile.h>
#include <exmodel/object.h>
#include <symtab/stype.h>


// Global variables used by the main program

cBlock *cCursor::Root = 0;
cSType *cSType::Head = 0;


/* extern "C" int Tcl_dotGraph_Init(Tcl_Interp*); */

int Tcl_AppInit(Tcl_Interp *interp)
{
   if (Tcl_Init(interp) == TCL_ERROR)  {
     cerr << "Error loading Tcl. Please check that your TCL_LIBRARY environment variable is set correctly." << endl;
     return TCL_ERROR;
   }
   if (Tk_Init(interp) == TCL_ERROR) {
     cerr << "Error loading Tk. Please check that your TK_LIBRARY environment variable is set correctly." << endl;
     return TCL_ERROR;
   }
   if (Itcl_Init(interp) == TCL_ERROR) {
     cerr << "Error loading [incr Tcl]. Please check that your ITCL_LIBRARY environment variable is set correctly." << endl;
     return TCL_ERROR;
   }

#if (TCL_MAJOR_VERSION > 7) || (TCL_MINOR_VERSION > 4)
    Tcl_StaticPackage(interp, "Itcl", Itcl_Init, (Tcl_PackageInitProc *) NULL);
#endif

   if (Itk_Init(interp) == TCL_ERROR) {
     cerr << "Error loading [incr Tk]. Please check that your ITK_LIBRARY environment variable is set correctly." << endl;
     return TCL_ERROR;
   }

   /* Dot package */
   /*
   if (Tcl_dotGraph_Init(interp) == TCL_ERROR) {
     return TCL_ERROR;
   }
   */
   if (Tix_Init(interp) == TCL_ERROR) {
     cerr << "Error loading Tix. Please check that your TIX_LIBRARY environment variable is set correctly." << endl;
     return TCL_ERROR;
   }

   // if (Exp_Init(interp) == TCL_ERROR)  return TCL_ERROR;

   return TCL_OK;
}

Tcl_Interp *main_interp;	/* Interpreter for this application. */


int main(int argc,
	 char *argv[])
{
   Tk_Window mainWindow; 
   int code;

   main_interp = Tcl_CreateInterp();
   mainWindow = Tk_MainWindow(main_interp);

   if (Tcl_AppInit(main_interp) != TCL_OK) {
     exit (1);
   }

   // Link a bunch of commands.

   Tcl_CreateCommand(main_interp, "next_prime", C2_next_prime,
		     (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
   Tcl_CreateCommand(main_interp, "c2_CreateProgramAST", C2_CreateProgramAST,
		     (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
   Tcl_CreateCommand(main_interp, "c2_CreateGraphAST", C2_CreateGraphAST,
		     (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
   Tcl_CreateCommand(main_interp, "c2_CreateCallNodeAST", C2_CreateCallNodeAST,
		     (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
   Tcl_CreateCommand(main_interp, "c2_CreateCompNodeAST", C2_CreateCompNodeAST,
		     (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
   Tcl_CreateCommand(main_interp, "c2_CreateCreationParameterNodeAST", C2_CreateCreationParameterNodeAST,
		     (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
   Tcl_CreateCommand(main_interp, "c2_CreateNameSharingNodeAST", C2_CreateNameSharingNodeAST,
		     (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
   Tcl_CreateCommand(main_interp, "c2_CreateInInterfaceNodeAST", C2_CreateInInterfaceNodeAST,
		     (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
   Tcl_CreateCommand(main_interp, "c2_CreateOutInterfaceNodeAST", C2_CreateOutInterfaceNodeAST,
		     (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
   Tcl_CreateCommand(main_interp, "c2_CreateArcAST", C2_CreateArcAST,
		     (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
   Tcl_CreateCommand(main_interp, "c2_TranslateAST", C2_TranslateAST,
		     (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
   Tcl_CreateCommand(main_interp, "c2_ParseCompNodeSpecification", C2_ParseCompNodeSpecification,
		     (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
   Tcl_CreateCommand(main_interp, "c2_ParseArcTopologyRule", C2_ParseArcTopologyRule,
		     (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
   Tcl_CreateCommand(main_interp, "c2_ParseFunctionSignatures", C2_ParseFunctionSignatures,
		     (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
   Tcl_CreateCommand(main_interp, "c2_ParseTypeDefinitions", C2_ParseTypeDefinitions,
		     (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
   Tcl_CreateCommand(main_interp, "c2_ParseNameSharingSpecification", C2_ParseNameSharingSpecification,
		     (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);


   TestDirectory = new char[255];
   sprintf (TestDirectory, ".");

   // Link a bunch of variables.

   Tcl_LinkVar(main_interp, "c2_SaveDirectory", (char *) &TestDirectory, TCL_LINK_STRING);
   Tcl_LinkVar(main_interp, "c2_yycolumn", (char *) &yycolumn, TCL_LINK_INT|TCL_LINK_READ_ONLY);
   Tcl_LinkVar(main_interp, "c2_yylinenum", (char *) &yylinenum, TCL_LINK_INT|TCL_LINK_READ_ONLY);
   Tcl_LinkVar(main_interp, "c2_ErrorUID", (char *) &C2_ErrorUID, TCL_LINK_INT);

   char *path;
   path = new char[255];
   char *s;
   s = new char[255];

   // Parse the command line.
   extern char *optarg;
   int c;
   char ss[255];
   char s1[255];
   int ExecuteString = 0;

   while ( (c = getopt (argc, argv, "c:f:ht:v-")) != EOF ) {
     switch (c) {
     case 'h':
       // Help.
       cout << "Usage: code [options]" << endl
	    << "Options:" << endl
	    << "  -c FILE          Compile a CODE program and exit." << endl 
	    << "  -f FILE          Load a CODE program." << endl
	    << "  -h               Show this summary of options." << endl
	    << "  -t TARGET        Select a compilation target (MPI, PVM, Serial, SMP)." << endl
	    << "  -v               Show version information." << endl
	    << endl;
       exit (0);
       break;
     case 'c':
       // Compile a given file to the default target and exit.
       ExecuteString = 1;
       sprintf (s1, "$c2_MainCanvas attempt_open \"%s\" ; Translate ; exit; ", optarg);
       strncat (ss, s1, 255);
       break;
     case 'f':
       // Try to open an input file.
       ExecuteString = 1;
       sprintf (s1, "$c2_MainCanvas attempt_open \"%s\"; ", optarg);
       strncat (ss, s1, 255);
       break;
     case 't':
       // Select a particular target.
       ExecuteString = 1;
       sprintf (s1, "set c2_TranslationTarget \"%s\" ; ", optarg);
       strncat (ss, s1, 255);
       break;
     case 'v':
       // Version information.
       cout << "CODE " << CODE_VERSION << endl
	    << "The CODE Visual Parallel Programming System" << endl
	    << "by Emery Berger, Peter Newton, Rajeev Vokkarne and Brian West." << endl
	    << "Copyright (C) 1997 The University of Texas at Austin." << endl
	    << "See http://www.cs.utexas.edu/users/code for more information." << endl
	    << endl;
       exit (0);
       break;
     case '-':
       goto doneparsing;
     }
   }
   
 doneparsing:
   
   // Check all of the *_LIBRARY variables.
   FILE * f;

   if (!(s = getenv("IWIDGETS_LIBRARY"))) {
     cerr << "Error loading [incr Widgets]. Please check that your IWIDGETS_LIBRARY environment variable is set correctly." << endl;
     exit(1);
   }
   sprintf (path, "%s/iwidgets.tcl", s);
   f = fopen (path, "r");
   if (!f) {
     cerr << "Error loading [incr Widgets]. Please check that your IWIDGETS_LIBRARY environment variable is set correctly." << endl;
     exit (1);
   }


   // If CODE_LIBRARY is defined, we use it;
   // otherwise, we use a default installation prefix.

   const char prefixstr[] = "/usr/local/lib/CODE";

   s = getenv("CODE_LIBRARY");
   if (!s) {
     s = new char[strlen(prefixstr) + 1];
     sprintf(s, prefixstr);
   }

   sprintf (path, "%s/ui/init.code2", s);
   f = fopen (path, "r");
   if (!f) {
     cerr << "Error loading CODE. Please check that your CODE_LIBRARY environment variable is set correctly." << endl;
     exit (1);
   }

   // Load the main Tcl program.

   code = Tcl_EvalFile(main_interp, path);

   if (ExecuteString) {
     Tcl_GlobalEval(main_interp, ss);
   }

   Tk_MainLoop();

   // The program has ended.

   if (code) {
     fprintf(stderr, "Error message = %s\n", main_interp->result);
     return(1);
   }

   /*
    * Don't exit directly, but rather invoke the Tcl "exit" command.
    * This gives the application the opportunity to redefine "exit"
    * to do additional cleanup.
    */

   Tcl_Eval(main_interp, "exit");

   return (0);

}
