#include <config.h>
#include <tcl.h>
#include <tk.h>
#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include <stdlib.h>

#include "massage.h"

int 
C2_MassageString(
   ClientData dummy, 
   Tcl_Interp *interp, 
   int argc, 
   char *argv[])
{
   dummy = dummy;  // silly code : eliminates compiler warning

   char *Input;
   char *Output;
   int i, j;

   if ( argc == 2 ) {
      Input = Tcl_GetVar(interp, argv[1], TCL_LEAVE_ERR_MSG);
      if ( Input != NULL ) {
         Output = (char *) malloc(strlen(Input)*4 + 1);
         for (i=0, j=0; i<strlen(Input); i++) {
            switch (Input[i]) {
            case '{':
	    case '}':
            case '\\':
            case ';':
            case '"':
            case '#':
            case '\'':
            case '%':
            case '$':
            case '[':
            case ']':
            case '@':
               sprintf(Output + j, "\\x%2x", Input[i]);
               j += 4;
               break;
            default:
               Output[j++] = Input[i];
            }
         }
         Output[j++] = '\0';
//printf("C2_MassageString : Input  is \"%s\"\n", Input);
//printf("C2_MassageString : Output is \"%s\"\n\n", Output);
         sprintf(interp->result, "%s", Output); // result is allocated TCL_RESULT_SIZE # of bytes
         return TCL_OK;
      } else {
         return TCL_ERROR;
      }
   } else {
      Tcl_AppendResult(interp, "c2_MassageString StringVariable is the correct invocation.");
      return TCL_ERROR;
   }
}
