/* c2_misc.h      Things included in all files.
 * 
 */

#ifndef _C2_MISC_
#define _C2_MISC_

  /* Include FastThreads headers */

#include <stdio.h>
#include "c2_forward.h"
#include "c2_general.h"

#ifdef _C2_DBGR_
#include <c2_udbg_intrf.h>		/* debugger's decl */
#endif 

  /* Things that we should not need but do */

extern char *_c2_shmalloc( /* unsigned size */ );


#include "c2_addrmap.h"


 /* Test for index equality */

int _c2_EqIndex(/* _c2_Index *i1; _c2_Index *i2; */);

/* AddrHashTab stuff */


  /* add array with given address and size to size table */

extern int _c2_AddrHashTabAdd(/* char *Addr, int Size */);

  /* Remove entry from size table */

extern int _c2_AddrHashTabRemove(/* char *Addr */);

  /* Split entry in table into two-- for when arrays are "split" by
     array distribution functions.  SplittingPoint is in bytes */

extern int _c2_AddrHashTabSplit(/* char *Addr, int SplittingPoint */);

  /* Look up size of array at addr */

extern int asize(/* char *Addr */);

  /* Initialize size table-- call before using other size table
     routines */

extern void _c2_AddrHashTabInit();

  /* keep track of amount of space allocated on heap */
unsigned _c2_totalloc;

#ifdef _c2_DBGR_
void _c2_reinitAddrHashTab();
#endif

#endif

