/* workers.c */

#include <stdio.h>
#include "c2_misc.h"
#include "c2_workers.h"


#include <limits.h>
#include <sys/times.h>
#include <time.h>


#ifndef CLOCKS_PER_SEC
#ifdef __sun
#define CLOCKS_PER_SEC 1000000
  extern long clock(void);
#else
#error Please define CLOCKS_PER_SEC
#endif
#endif



#ifdef _C2_DBGR_
#include <debugQ.h>
#endif

int _c2_Terminated;  /* 1 iff term node has fired */

static  _c2_RQLink *Head;
static  _c2_RQLink *FreeList;

static float _c2_SysSec;
static float _c2_UserSec;


void _c2_StartClock() {
  struct tms before;
  clock_t start_time;

  start_time  = times(&before);
  _c2_SysSec  = (float)before.tms_stime/(float)CLOCKS_PER_SEC;
  _c2_UserSec = (float)before.tms_utime/(float)CLOCKS_PER_SEC;

}

void _c2_StopClock() {
  struct tms after;
  clock_t end_time;

  end_time    = times(&after);
  _c2_SysSec  = (float)after.tms_stime/(float)CLOCKS_PER_SEC - _c2_SysSec;
  _c2_UserSec = (float)after.tms_utime/(float)CLOCKS_PER_SEC - _c2_UserSec;
}


   /* Signal a halt to the computation */

void _c2_StopAll()
{
  printf("Computation complete.\n");
  printf("Time between completion of Start node and firing of Stop node:\n");
  printf("  Total time : %f seconds.\n", _c2_SysSec+_c2_UserSec); 
  printf("  System time: %f seconds.\n", _c2_SysSec);
  printf("  User time  : %f seconds.\n", _c2_UserSec);

  _c2_Terminated = 1;
  fflush(stdout);
  fflush(stderr);
}


void _c2_KillComp(Reason)
   int Reason;
{
   fprintf(stderr, "\n\n*** CODE fatal runtime error: ");
   switch (Reason) {
     case _c2_CREPTWICE:
       fprintf(stderr, "Attempt to bind 2nd value to creation parameter\n");
       break;
     case _c2_RMFROMEMPTY:
       fprintf(stderr, "Attempt to remove from empty arc\n");
       break;
     default:
       fprintf(stderr, "Unknown problem (internal error?)\n");
       break;
   }
   fflush(stdout);
   fflush(stderr);

   _c2_Terminated = 1;
}

   /* Add a node to the Ready Q */

void _c2_EnQueue(NodeToAdd)
   _c2_NodeBase *NodeToAdd;
{
   _c2_RQLink *tmp;

#ifdef DEBUG
/*   printf("Adding node with UID %d to Ready Q\n",
	  NodeToAdd->UID); */
#endif


   if (!(NodeToAdd->Crepped)) {  /* Node cannot be run until creps are bound */
      return;
   }

   switch (NodeToAdd->QueueStatus) {
    case _c2_IDLE:
      NodeToAdd->QueueStatus = _c2_ONQUEUE;
      NodeToAdd->Attempts++;

#     ifdef _C2_DBGR_
         _c2_timeUcPutOnRdyQ(NodeToAdd); /* performance measurement */
#     endif
      break;
    case _c2_ONQUEUE:
    case _c2_RUNNING:
      NodeToAdd->Attempts++;
      return;

#   ifdef _C2_DBGR_
    case _c2_ONDBGQ: /* debugger will later run it */
      return;
#   endif

    default:
      fprintf(stderr, "Error: Illegal Q status in _c2_EnQueue\n");
      fflush(stdout);
      fflush(stderr);
      _c2_StopAll();
   }

   /* If we get here, we need to Q to node */

   if (FreeList != 0) {
      tmp = FreeList;
      FreeList = FreeList->Next;
   } else
     tmp = (_c2_RQLink *) _c2_shmalloc(sizeof(_c2_RQLink));
   tmp->Node = NodeToAdd;
   tmp->Next = Head;
   Head = tmp;

   return;
}


   /* Get a node to run from the ready Q, return 0 if Q empty */

static _c2_NodeBase *_c2_PopNode()
{
   _c2_NodeBase *ReturnTask;
   _c2_RQLink *TmpHead;


   if (Head == 0) {
      return 0;
   }

   TmpHead = Head;
   Head = Head->Next;
   ReturnTask = TmpHead->Node;

   TmpHead->Next = FreeList;
   FreeList = TmpHead;

   switch (ReturnTask->QueueStatus) {
    case _c2_ONQUEUE:
      ReturnTask->QueueStatus = _c2_RUNNING;
      break;
    default:
      fprintf(stderr, "Error: Illegal Q status in _c2_PopNode\n");
      fflush(stderr);
      fflush(stdout);
      _c2_StopAll();
   }

   return ReturnTask;
}


   /* Process for a worker-- a FastThreads Thread that runs nodes on the
      ready Q */

 void _c2_WorkerTask(ID)
   int ID;
{
   _c2_NodeBase *NodeToRun;
   int RunCount = 0;
   int ReRunCount = 0;
   int IdleCount = 0;
   int TotalCount = 0;

#  ifdef DEBUG /* Peter's internal debugging */
   printf("Worker %d starts\n", ID);
#  endif

   while (!_c2_Terminated) {
#     ifdef _C2_DBGR_
            if (_c2_GlobalState == _c2_STOPPED)  break; /* go look at news */
#     endif

      TotalCount++;
#     ifdef DEBUG
        if (TotalCount % 50000 == 0) {
	   printf("Worker %d: Total %d, Idle %d, Runs %d, Reruns %d\n",
		  ID, TotalCount, IdleCount, RunCount, ReRunCount);
	   fflush(stdout);
	} 
#     endif

      /* Check ready queue for a node to run */

      if ( Head == 0 || (NodeToRun = _c2_PopNode()) == 0) {
#     ifdef _C2_DBGR_
	 if (_c2_sizeOutDbgQ() == 0 || (NodeToRun = _c2_PopOutDbgQ()) == 0) {
	    _c2_assertWrkrState(ID);
	    IdleCount++;                                                           
	    break;  /* go look at news from the instrumentation */
	 }
#     else  /* not _C2_DBGR_ */
	 printf("Non-termination detected.\n");
	 _c2_Terminated = 1;
#if 0
	 IdleCount++;
#endif
	 continue;  /* nothing to do */

#     endif /* _C2_DBGR_ */
      }

      RunCount++;

#     ifdef DEBUG
      printf("Worker %d Running a %d\n", ID, NodeToRun->UID);
      fflush(stdout);

#     endif

    Again:
      NodeToRun->CompProc(NodeToRun);
      NodeToRun->Attempts--;
      ASSERT (NodeToRun->Attempts >= 0);

      switch (NodeToRun->QueueStatus) {
#      ifdef _C2_DBGR_
       case _c2_ONDBGQ:         /* debugger will run it later on */
         break;
#      endif
       case _c2_RUNNING:
	 NodeToRun->QueueStatus = _c2_IDLE;
	 /*
	  * Re-queue this node until all attempts at running have
	  * occurred.
	  */
	 
	 ASSERT (NodeToRun->Attempts >= 0);
	 
	 if (NodeToRun->Attempts > 0) {
	   NodeToRun->Attempts--;
	   _c2_EnQueue (NodeToRun);
	   ASSERT (NodeToRun->QueueStatus == _c2_ONQUEUE);
	 }
	 break;
       default:
	 MESSAGE ("Illegal queue status in worker.");
	 _c2_StopAll();
	 break;
      }
   }
   if (_c2_Terminated) {
#if 0
      printf("Worker %d: Total %d, Idle %d, Runs %d, Reruns %d\n",
	     ID, TotalCount, IdleCount, RunCount, ReRunCount);
      printf("Worker %d terminates\n", ID);
#endif
   }
}

void _c2_RunWorkers(InitNode)
   _c2_NodeBase *InitNode;
{

   Head = 0;
   FreeList = 0;
   _c2_Terminated = 0;

   /* enqueue the start node */
   _c2_EnQueue(InitNode);

   _c2_WorkerTask(0);

}

#ifdef _C2_DBGR_


void _c2_RunDebugger(InitNode, argc, argv)
   _c2_NodeBase *InitNode;
     int argc;
     char **argv;
{
   _c2_saveInitNode(InitNode);
   _c2_ScopeInit(InitNode->MyGraph);
   _c2_Terminated = 0;

   _c2_dbginstalled = 1;        /* install one debugger task also  */
   _c2_initWrkrDbg(0);

   _c2_DebuggerTask(0, argc, argv); /*  0, because debugger and worker will be running 
                                     on the same process*/
}


void _c2_emptyRdyQ()
{
   while(_c2_PopNode())
     ;
}


/* Dummies for compatiblity with FastThreads */

void _c2_KillWorkers()
{
   int i;
}

void _c2_inthandler()
{
   int i;
}

void _c2_ChldHndler()
{ 
   int i;
}

#endif
