/*
  c2_workers.h
  ------------------------------------------------------------------------
  
  ------------------------------------------------------------------------
  @(#) $Id: c2_workers.h,v 1.9 1997/07/01 18:40:42 emery Exp $
  ------------------------------------------------------------------------
  AUTHOR/CONTACT:
 
  Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
  Systems Analyst                 @           <mailto:emery@cs.utexas.edu>
  Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
  Department of Computer Sciences |             <http://www.cs.utexas.edu>
  University of Texas at Austin   |                <http://www.utexas.edu>
  ========================================================================
*/

#ifndef _C2_WORKERS_
#define _C2_WORKERS_

#include "c2_general.h"

extern int _c2_Terminated;  /* 1 iff term node has fired */

  /* Initial worker manager-- call this first with address of start node */
void _c2_RunWorkers( /* _c2_NodeBase *InitNode */ );

  /* Add a NodeTask to the list to be run */
void _c2_EnQueue( /* _c2_NodeBase *Node */ );

  /* Signal end to computation */
void _c2_StopAll();

  /* Stop computation after error */
void _c2_KillComp( /* int Reason */ );


         /* AbEnd reasons */

#define _c2_CREPTWICE 1
#define _c2_RMFROMEMPTY 2

#ifdef _C2_DBGR_
   /* runs the debugger task after the initialization of runtime system */
void _c2_RunDebugger(/* _c2_NodeBase *InitNode, int argc, char **argv */);

   /* empty ready q in preparation for a new run by the debugger */
void _c2_emptyRdyQ();

   /* Dummy routines to provide compatiblity with sequent runtime*/
void _c2_KillWorkers();
void _c2_inthandler();
void _c2_ChldHndler();

#endif

#endif
