/*
  Unmessenger.H
  ------------------------------------------------------------------------
  Null messenger class (no message passing at all).
  ------------------------------------------------------------------------
  @(#) $Id: Unmessenger.H,v 1.11 1998/08/04 17:34:41 emery Exp $
  ------------------------------------------------------------------------
  AUTHOR/CONTACT:
 
  Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
  Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
  Department of Computer Sciences |             <http://www.cs.utexas.edu>
  University of Texas at Austin   |                <http://www.utexas.edu>
  ========================================================================
*/

#ifndef _UNMESSENGER_H_
#define _UNMESSENGER_H_

#include <assert.h>

#include "atomic.H"
#include "messenger.H"


// This class is an UnMessenger --
// it is nothing but a set of stub implementations
// for use with uniprocessor or SMPs, where
// message-passing is not needed.

class UnMessenger : public Messenger {
public:

  UnMessenger (void) {  }

  ~UnMessenger (void) { }

  int self (void) { return 0; }
  int numProcessors (void) { return 1; }

  void initialize (int& argc, char **& argv) { }
  void finalize (void) { }

  void send (const int, const int) { assert (0); }

  int receive (void)
    {
      return 0; 
    }

  int poll (void) { return 0; }
  int flush (void) { return 0; }

  void broadcast (const int, const int, const int) {  }

  void pack (const char) {  }
  void pack (const int) {  }
  void pack (const int *, const int ) {  }
  void pack (const double *, const int) {  }
  void pack (const float *, const int) {  }
  void pack (const char *, const int) {  }

  void pack (const long) {  }
  void pack (const double) {  }
  void pack (const float) {  }
  void pack (const char *) {  }
  void pack (char *) {  }

  // unpack data from the receive buffer.
  void unpack (char&) {  }
  void unpack (int&) {  }
  void unpack (int*, const int) {  }
  void unpack (double *, const int) {  }
  void unpack (float *, const int) {  }
  void unpack (char *, const int = 0) {  }

  void unpack (long&) {  }
  void unpack (double&) {  }
  void unpack (float&) {  }
  void unpack (char*) {  }

  // the length of the just-received message.
  int messageLength (void) { return 0; }

  // the sender of the just-received message.
  int messageSender (void) { return 0; }

  // the tag on the just-received message.
  int messageTag (void) { return 0; }

  // is there is a message waiting to be received?
  int messageWaiting (void) { return 0; }

};

#endif
