/*
 * c2_addrmap.c
 * ------------------------------------------------------------------------
 * Address map functions (i.e., keeping track of instances of nodes in
 * graphs).
 * ------------------------------------------------------------------------
 * @(#) $Id: c2_addrmap.C,v 1.17 1998/03/17 00:57:06 emery Exp $
 * ------------------------------------------------------------------------
 * AUTHOR:
 *
 * Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
 * Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
 * Department of Computer Sciences |             <http://www.cs.utexas.edu>
 * University of Texas at Austin   |                <http://www.utexas.edu>
 * ========================================================================
 */

#include <assert.h>
#include <stdio.h>

#include "header.H"
#include "c2_addrmap.h"

#include "graph.H"
#include "node.H"
#include "nsrel.H"

#include "c2_misc.h"
#include "c2_workers.h"


/*
 * Return address within Graph's map of object with given UID and Index.  UID
 * of 0 yields address of parent graph
 */

#ifdef __cplusplus
extern "C"
#endif

void *_c2_GetAddr (Graph * Graph, int UID, Index * Index, SerialMachine * SerMach)
{
  ASSERT (Graph != NULL);
  ASSERT (Index != NULL);

  if (UID == 0) {
    return (void *) Graph->GetParent();
  } else {
    // cout << "GetAddr called with graph " << Graph->GetPathName().str() << " for UID " << UID << ", index " << *Index << endl;
    return Graph->Find (UID, Index, SerMach);
  }
}
