/*
 * c2_workers.c
 * ------------------------------------------------------------------------
 * Manages running of tasks.
 * ------------------------------------------------------------------------
 * @(#) $Id: c2_workers.C,v 1.42 1998/11/06 05:12:01 emery Exp $
 * ------------------------------------------------------------------------
 * AUTHOR/CONTACT:
 *
 * Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
 * Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
 * Department of Computer Sciences |             <http://www.cs.utexas.edu>
 * University of Texas at Austin   |                <http://www.utexas.edu>
 * ========================================================================
 */


#include <stdio.h>
#include <stdlib.h>

#include "header.H"
#include "c2_workers.h"
#include "machine.H"
#include "messenger.H"
#include "graph.H"
#include "node.H"
#include "nsrel.H"

#include "c2_addrmap.h"

const char * KillCompErrorMsg[] = {
  "(unknown)",
  "Attempt to bind second value to creation parameter.",
  "Attempt to remove data from an empty arc.",
  "Illegal queue status in _c2_EnQueue.",
  "Illegal queue status in _c2_PopNode.",
  "Illegal queue status in _c2_WorkerTask.",
  "Attempt to use two instances of a shared variable.",
  "Memory allocation attempt failed.",
  "No such NSRel in message handler or CopyNSRel.",
  "No such UID in MakeObj, CopyUC or CopyGraph.",
  "No such arc in remote data transfer."
};

CODE_Machine * TheMachine;

float _c2_SysSec;

float _c2_UserSec;

float _c2_WallClockSec;


void _c2_KillComp (int Reason)
{

   fprintf (stderr, "\n\n*** CODE fatal runtime error: %s\n", KillCompErrorMsg[Reason]);
   
   fflush (stdout);
   fflush (stderr);

   abort();
}


static void ParseArgs (int argc,
		       char * argv[],
		       int& numthreads)
{
  int c;

  numthreads = 1;

  // LINUX doesn't have getopt, etc.

#ifdef __SVR4
  // extern char *optarg;
  // extern int optind;
     
  while ( (c = getopt (argc, argv, "n:h-")) != EOF ) {
    switch (c) {
    case 'n': numthreads = atoi (optarg); break;
    case 'h':
      cout << "Usage: " << argv[0] << " <options>\n";
      cout << "options:\n";
      cout << "  -n N : Use N workers (processors).\n";
      cout << flush;
      exit (0);
      break;
    case '-':
      goto doneparsing;
    }
  }

doneparsing:

  if (numthreads <= 0) {
    cout << "Error: The number of workers must be greater than zero.\n";
    cout << flush;
    exit (1);
  }

  if (numthreads > CODE_Machine::MAX_THREADS) {
    cout << "Error: The number of workers can't be greater than "
	 << CODE_Machine::MAX_THREADS
	 << ".\n";
    cout << flush;
    exit (1);
  }
#endif // __LINUX__
}


// Initialize and run the program.
// Pass in an array of messengers as the last arg.

void _c2_startup (int argc,
		  char * argv[],
		  char *,			// ProgramName
		  int StartGraphUID,
		  int StartNodeUID,
		  char *,			// StartNodePath
		  Messenger** messengers)
{
  extern int numWorkers;    // defined in CODE-created main.
  extern int numProcessors; // defined in CODE-created main.
  extern Graph * MainGraph; // defined in CODE-created main.

  Index Index;
  CompNode * StartNode;
  int ObjType;

  //  _c2_AddrHashTabInit ();

  // Perform any necessary initializations.

  messengers[0]->initialize (argc, argv);

  // Parse out any CODE options from the command-line.
  ParseArgs (argc, argv, numWorkers);

  TheMachine = new CODE_Machine (messengers, numWorkers, true);

  numProcessors = messengers[0]->numProcessors();

  MainGraph = (Graph *) _c2_MakeObj (StartGraphUID,
				     &Index,
				     NULL,
				     &ObjType,
				     &TheMachine->GetSerialMachine(0));

  StartNode = (CompNode *) _c2_GetAddr (MainGraph, StartNodeUID, &Index, &TheMachine->GetSerialMachine(0));

  TheMachine->Run (StartNode);

  messengers[0]->finalize ();

  // The line below should be innocuous but it causes
  // a core dump on Linux...

  // delete MainGraph;

  exit(0);
}
