/*
  c2_workers.h
  ------------------------------------------------------------------------
  
  ------------------------------------------------------------------------
  @(#) $Id: c2_workers.h,v 1.20 1997/10/24 15:29:26 emery Exp $
  ------------------------------------------------------------------------
  AUTHOR/CONTACT:
 
  Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
  Systems Analyst                 @           <mailto:emery@cs.utexas.edu>
  Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
  Department of Computer Sciences |             <http://www.cs.utexas.edu>
  University of Texas at Austin   |                <http://www.utexas.edu>
  ========================================================================
*/

#ifndef _C2_WORKERS_H
#define _C2_WORKERS_H

#include <stdio.h>

#include "readyq.H"

class _c2_GraphBase; // forward declaration
class CompNode; // forward declaration
class Messenger; // forward declaration

//extern _c2_Execution *execution_head;

extern float _c2_SysSec;

extern float _c2_UserSec;

extern float _c2_WallClockSec;


  // Stop computation after error 
extern void _c2_KillComp(int Reason);

// Initialize and run the program.
void _c2_startup (int argc,
		  char * argv[],
		  char * ProgramName,
		  int StartGraphUID,
		  int StartNodeUID,
		  char * StartNodePath,
		  Messenger **_messenger);


         // AbEnd reasons 

const int _c2_CREPTWICE = 1;	// Attempt to bind second value to creation parameter. 
const int _c2_RMFROMEMPTY = 2;	// Attempt to remove data from an empty arc. 
const int _c2_ILLEGALQSTATUS_ENQUEUE = 3; // Illegal queue status in _c2_EnQueue. 
const int _c2_ILLEGALQSTATUS_POP = 4;	// Illegal queue status in _c2_PopNode. 
const int _c2_ILLEGALQSTATUS_WORKER = 5; // Illegal queue status in _c2_WorkerTask. 
const int _c2_2INSTANCESSHAREDVAR = 6;	// Attempt to use two instances of a shared variable. 
const int _c2_MALLOCFAIL = 7;	// Memory allocation attempt failed. 
const int _c2_NOSUCHNSREL = 8;	// No such NSRel in message handler or CopyNSRel. 
const int _c2_NOSUCHUID = 9;	// No such UID in MakeObj, CopyUC or CopyGraph. 
const int _c2_NOSUCHARC = 10;	// No such arc in remote data transfer. 


#ifdef _C2_DBGR_
// Instead of running the workers, run the debugger first 
void _c2_RunDebugger(CompNode *InitNode, int argc, char **argv);

// empty the queue for a new run 
void _c2_emptyRdyQ();

// to handle sigsegv that can not be handled in sequent 
void _c2_ChldHndler();

// Kill all the workers on exit from the debugger 
void _c2_KillWorkers();

// handle the interrupt in c2dbgamin.c 

void _c2_inthandler();

#endif // _C2_DBGR_ 


#endif // _C2_WORKERS_H 
