/*
  codedata.H
  ------------------------------------------------------------------------
  Base class for CODE LocalData objects.
  Acts as a wrapper around the CODE-declared structs,
  providing useful copy functions for message-passing.
  ------------------------------------------------------------------------
  @(#) $Id: codedata.H,v 1.9 1998/05/28 22:51:26 emery Exp $
  ------------------------------------------------------------------------
  AUTHOR/CONTACT:
 
  Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
  Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
  Department of Computer Sciences |             <http://www.cs.utexas.edu>
  University of Texas at Austin   |                <http://www.utexas.edu>
  ========================================================================
*/

#ifndef _CODEDATA_H_
#define _CODEDATA_H_

#include <assert.h>
#include <string.h>

#include "sermach.H"
#include "machine.H"
#include "messenger.H"
#include "fthread.h"
#include "heap.H"
#include "unique.H"




class CodeDataBase {
public:
  CodeDataBase (void * value)
    : _value (value)
    { }

  ~CodeDataBase (void) { delete _value; }

  // Return the size of the encapsulated structure.
  virtual int	size (void) const = 0;

  // Const and non-const versions of accessors to the
  // encapsulated struct.
  const void * data (void) const	{ return _value; }
  void * data (void)		{ return _value;}

protected:
  void * _value;
};


template <class TYPE>
class CodeData : public CodeDataBase, private Unique {
public:

  CodeData (SerialMachine * sm)
    : CodeDataBase (new (sm->GetHeap()) TYPE),
      _SerialMachine (sm)
    {
      assert (sm);
    }

  CodeData (void)
    : CodeDataBase (new TYPE),
      _SerialMachine (NULL)
    {}

  int size (void) const		{ return sizeof(TYPE); }

  inline void * operator new (size_t sz, SerialMachine * sm);

  void * operator new (size_t sz) {
    return (void *) ::new char[sz];
  }

  void operator delete (void * p) {}

  SerialMachine * _SerialMachine;
};


template <class TYPE>
inline void * CodeData<TYPE>::operator new (size_t sz, SerialMachine * sm)
{
  assert (sm);
  return sm->alloc (sz);
}


#endif // _CODEDATA_H_
