/*
  codeobject.H
  ------------------------------------------------------------------------
  Generic CODE object class definition.
  ------------------------------------------------------------------------
  @(#) $Id: codeobject.H,v 1.20 1998/11/06 05:12:51 emery Exp $
  ------------------------------------------------------------------------
  AUTHOR/CONTACT:
 
  Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
  Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
  Department of Computer Sciences |             <http://www.cs.utexas.edu>
  University of Texas at Austin   |                <http://www.utexas.edu>
  ========================================================================
*/


#ifndef _CODEOBJECT_H_
#define _CODEOBJECT_H_

#include <iostream.h>

#include "header.H"
#include "codedata.H"
#include "index.H"
#include "path.H"
#include "unique.H"

class Graph;		// forward declaration
class SerialMachine;		// forward declaration


// The root of all CODE objects.

class CodeObject : public Unique {
  friend ostream& operator<<(ostream&, CodeObject&);
public:

  typedef enum { UC, NSREL, GRAPH } ObjectType;

  // Accessors.

  ObjectType GetType (void) { return _Type; }

  CodeDataBase * LocalData (void) { return _LocalData; }
  const CodeDataBase * const LocalData (void) const { return _LocalData; }

  const Graph * const MyGraph (void) const { return _MyGraph; }
  Graph * MyGraph (void) { return const_cast(Graph *, _MyGraph); }

  const Index& MyIndex (void) const { return _Index; }

  Pathname& GetPathName (void) { return _Path; }
  const Pathname& GetPathName (void) const { return _Path; }

  const int ID (void) const { return _UID; }

  SerialMachine& GetMachine (void); // { return *_Machine; }
  void SetMachine (SerialMachine& sermach); // { _Machine = sermach; }


  // See below for the meaning of these arguments.
  CodeObject (int uid,
	      Index * index,
	      CodeDataBase * localdata,
	      Graph * mygraph,
	      SerialMachine * machine,
	      ObjectType type)
    : _lock ("CodeObject::Lock"),
      _UID (uid),
      _Index (*index),
      _LocalData (localdata),
      _Machine (machine),
      _MyGraph (mygraph),
      _Processor (-1),			// The processor has not yet been computed.
      _Path(*this),
      _Type (type)
  {
    // Perform a few sanity checks.
    assert (_UID > 0);
    assert (index != NULL);
    assert (localdata != NULL);
  }

  virtual ~CodeObject (void) 
    {
      delete _LocalData;
    }

  // Return the processor that this object "lives" on.
  virtual int Processor (void) = 0;


protected:

  mutable MutexRec	_lock;		// Protects the entire data structure.

  //double _pad1[PAD_DBL]; // padding to avoid false sharing.

  //mutable MutexRec	_LocalDataLock;	// Lock for the _LocalData structure.

  //double _pad2[PAD_DBL]; // padding to avoid false sharing.

  const int            	_UID;		// Unique ID number 
  const Index    	_Index;		// My index (e.g., foo[i][j]).
  CodeDataBase *       	_LocalData;	// Pointer to local variables wrapper.
  SerialMachine *	_Machine;	// What machine this object is attached to.
  const Graph*		_MyGraph;	// My graph.
  Pathname		_Path;		// Full pathname of node. 
  mutable int    	_Processor;	// Processor that this object actually resides on.
  ObjectType		_Type;
};

#endif /* _CODEOBJECT_H_ */
