#ifndef _DEQ_H_
#define _DEQ_H_

#include <assert.h>
#include <stdlib.h>
#include <malloc.h>


#include "sermach.H"

// class SerialMachine; // forward declaration

#pragma interface

template <class T>
class deq;

template <class T>
class deqobj {
public:

  deqobj (void) {}

  deqobj (T value)
    : _value (value)
    {}

  deqobj (T& value, deqobj<T> * prev, deqobj<T> * next)
    : _value (value),
      _prev (prev),
      _next (next)
    {}

  deqobj (deqobj<T> * prev, deqobj<T> * next)
    : _prev (prev),
      _next (next)
    {}

  inline void * operator new (size_t sz, SerialMachine * sermach);
  void operator delete (void *) {}

  deqobj<T> *& prev (void) { return _prev; }
  const deqobj<T> * prev (void) const { return _prev; }

  deqobj<T> *& next (void) { return _next; }
  const deqobj<T> * next (void) const { return _next; }

  operator T (void) { return _value; }
  operator const T (void) const { return _value; }

private:
  T	_value;
  deqobj<T> * _prev;
  deqobj<T> * _next;
};


template <class T>
class deqobj_iterator {
public:

  friend int operator== (const deqobj_iterator<T>& a, const deqobj_iterator<T>& b);
  friend int operator!= (const deqobj_iterator<T>& a, const deqobj_iterator<T>& b);

  deqobj_iterator (void) {}

  deqobj_iterator (deqobj<T> * ptr)
    : _deqobjptr (ptr)
    {}

  deqobj_iterator (const deqobj<T> * ptr)
    : _deqobjptr ((deqobj<T> *) ptr)
    {}

  T operator * (void) { return *_deqobjptr; }
  const T operator * (void) const { return *_deqobjptr; }

  operator deqobj<T> * (void) { return _deqobjptr; }
  operator const deqobj<T> * (void) const { return _deqobjptr; }

  deqobj_iterator<T>& operator++ (void) { _deqobjptr = _deqobjptr->next (); return *this; }
  deqobj_iterator<T>& operator++ (int)  { _deqobjptr = _deqobjptr->next (); return *this; }
  deqobj_iterator<T>& operator-- (void) { _deqobjptr = _deqobjptr->prev (); return *this; }
  deqobj_iterator<T>& operator-- (int)  { _deqobjptr = _deqobjptr->prev (); return *this; }

private:
  deqobj<T> * _deqobjptr;
};


template <class T>
int operator== (const deqobj_iterator<T>& a, const deqobj_iterator<T>& b)
{
  return a._deqobjptr == b._deqobjptr;
}


template <class T>
int operator!= (const deqobj_iterator<T>& a, const deqobj_iterator<T>& b)
{
  return a._deqobjptr != b._deqobjptr;
}


template <class T>
class deq {
public:

  deq (SerialMachine * sermach)
    : _sermach (sermach),
      _size (0),
      _head (&_tail, &_tail),
      _tail (&_head, &_head)
    {}

  deq (void)
    : _sermach (0),
      _size (0),
      _head (&_tail, &_tail),
      _tail (&_head, &_head)
    {}

  typedef deqobj_iterator<T> iterator;
  typedef const deqobj_iterator<T> const_iterator;

  iterator begin (void) { return deqobj_iterator<T> (head()); }
  const_iterator begin (void) const { return deqobj_iterator<T> (head()); }

  iterator end (void) { return deqobj_iterator<T> (&_tail); }
  const_iterator end (void) const { return deqobj_iterator<T> (&_tail); }

  unsigned int size (void) { return _size; }
  const unsigned int size (void) const { return _size; }

  int empty (void) { return (size() == 0); }
  const int empty (void) const { return (size() == 0); }

  T front (void) { assert (!empty()); return (T) *head(); }
  const T front (void) const { assert (!empty()); return (const T) *head(); }
  
  T back (void) { assert (!empty()); return (T) *tail(); }
  const T back (void) const { assert (!empty()); return (const T) *tail(); }

  void erase (iterator p) {
    assert (_size > 0);
    deqobj<T> * ptr = p;
    ptr->prev()->next() = ptr->next();
    ptr->next()->prev() = ptr->prev();
    --_size;
    assert (_size >= 0);
    delete ptr;
  }

  void push_front (T v) {
    deqobj<T> * newptr;
    newptr = new (_sermach) deqobj<T> (v, &_head, head());
    _push_front (newptr);
  }

  void push_front (T v, SerialMachine * sm) {
    deqobj<T> * newptr;
    newptr = new (sm) deqobj<T> (v, &_head, head());
    _push_front (newptr);
  }

  void push_back (T v) {
    deqobj<T> * newptr;
    newptr = new (_sermach) deqobj<T> (v, tail(), &_tail);
    _push_back (newptr);
  }

  void push_back (T v, SerialMachine * sm) {
    deqobj<T> * newptr;
    newptr = new (sm) deqobj<T> (v, tail(), &_tail);
    _push_back (newptr);
  }

  void pop_front (void) {
    assert (!empty());
    erase (begin());
  }

  void pop_back (void) {
    assert (!empty());
    erase (deqobj_iterator<T> (tail()));
  }

  inline void * operator new (size_t sz, SerialMachine * sermach);
  void operator delete (void * p) {}

private:

  void _push_front (deqobj<T> * newptr) {
    head()->prev() = newptr;
    head() = newptr;
    ++_size;
  }

  void _push_back (deqobj<T> * newptr) {
    tail()->next() = newptr;
    tail() = newptr;
    ++_size;
  }

  deqobj<T> *& head (void) { return _head.next(); }
  const deqobj<T> * head (void) const { return _head.next(); }

  deqobj<T> *& tail (void) { return _tail.prev(); }
  const deqobj<T> * tail (void) const { return _tail.prev(); }

  SerialMachine * _sermach;
  int _size;
  deqobj<T> _head;
  deqobj<T> _tail;
};


template <class T>
inline void * deqobj<T>::operator new (size_t sz, SerialMachine * sermach)
{
  return sermach->alloc (sz);
}

template <class T>
inline void * deq<T>::operator new (size_t sz, SerialMachine * sermach)
{
  return sermach->alloc (sz);
}


#endif // _DEQ_H_
