/*
  fsynch.c
  ------------------------------------------------------------------------
  Wrappers for POSIX synchronization variables.
  ------------------------------------------------------------------------
  @(#) $Id: fsynch.C,v 1.12 1998/03/17 00:57:11 emery Exp $
  ------------------------------------------------------------------------
  AUTHOR/CONTACT:
 
  Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
  Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
  Department of Computer Sciences |             <http://www.cs.utexas.edu>
  University of Texas at Austin   |                <http://www.utexas.edu>
  ========================================================================
*/


#include <stdio.h>
#include <time.h>

#include "fthread.h"
#include "fsynch.h"


void ConditionInit (Cond *cond) {
  pthread_cond_init (cond, NULL);
}

void LockInit (Lock *lock, ...) {
  pthread_mutex_init (lock, NULL);
}

int ConditionTimedWait (Cond * cond, Lock * lock, int sec)
{
  struct timespec abstime;
  abstime.tv_sec = time (NULL) + sec;
  abstime.tv_nsec = 0;
  return (pthread_cond_timedwait (cond, lock, &abstime));
}
