/*
  fsynch.h
  ------------------------------------------------------------------------
  Wrappers for POSIX synchronization variables.
  ------------------------------------------------------------------------
  @(#) $Id: fsynch.h,v 1.11 1998/03/17 00:57:12 emery Exp $
  ------------------------------------------------------------------------
  AUTHOR/CONTACT:
 
  Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
  Systems Analyst                 @           <mailto:emery@cs.utexas.edu>
  Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
  Department of Computer Sciences |             <http://www.cs.utexas.edu>
  University of Texas at Austin   |                <http://www.utexas.edu>
  ========================================================================
*/

#ifndef _fastsynch_x
#define _fastsynch_x

#include "fthread.h"

/* define lock routines */

typedef pthread_mutex_t Lock;
typedef pthread_cond_t Cond;

extern void ConditionInit (Cond *cond);
extern int ConditionTimedWait (Cond * cond, Lock * lock, int sec);

#define ConditionWait(c,m) pthread_cond_wait((c), (m))
#define ConditionBroadcast(c) pthread_cond_broadcast((c))
#define ConditionSignal(c) pthread_cond_signal((c))
#define ConditionDestroy(c) pthread_cond_destroy((c))

extern void LockInit (Lock *lock, ...);
#define LockAcquire(lock) pthread_mutex_lock((lock))
#define LockTryAcquire(lock) pthread_mutex_trylock((lock))     
#define LockRelease(lock) pthread_mutex_unlock((lock))

#endif
