/*
  fthread.c
  ------------------------------------------------------------------------
  POSIX thread wrappers.
  ------------------------------------------------------------------------
  @(#) $Id: fthread.C,v 1.14 1998/08/04 20:55:25 emery Exp $
  ------------------------------------------------------------------------
  AUTHOR/CONTACT:
 
  Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
  Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
  Department of Computer Sciences |             <http://www.cs.utexas.edu>
  University of Texas at Austin   |                <http://www.utexas.edu>
  ========================================================================
*/

#include <stdlib.h>

#include "fthread.h"

#include <stdio.h>
#include <limits.h>


void BoundThread::start (void (*procedureToRun)(void *),
			 void *arg)
{
#ifdef PTHREAD_CREATE_JOINABLE
  pthread_attr_setdetachstate (&_attr, PTHREAD_CREATE_JOINABLE);
#else
#  ifdef PTHREAD_CREATE_UNDETACHED
  pthread_attr_setdetachstate (&_attr, PTHREAD_CREATE_UNDETACHED);
#  else
#  error "CODE requires a POSIX-compliant threads package."
#  endif
#endif

#if __SVR4
  pthread_attr_setscope (&_attr, PTHREAD_SCOPE_SYSTEM); /* bound behavior */
#endif

  int result = pthread_create (&_thread, &_attr, (void *(*)(void*))procedureToRun, (void *) arg);

  if (result) {
    printf("Error %d received.\n", result);
    exit(1);
  }
}


void Thread::start (void (*procedureToRun)(void *),
		    void *arg)
{
#ifdef PTHREAD_CREATE_JOINABLE
  pthread_attr_setdetachstate (&_attr, PTHREAD_CREATE_JOINABLE);
#else
#  ifdef PTHREAD_CREATE_UNDETACHED
  pthread_attr_setdetachstate (&_attr, PTHREAD_CREATE_UNDETACHED);
#  else
#  error "CODE requires a POSIX-compliant threads package."
#  endif
#endif

  int result = pthread_create (&_thread, &_attr, (void *(*)(void*))procedureToRun, (void *) arg);

  if (result) {
    printf("Error %d received.\n", result);
    exit(1);
  }
}


void Thread::join (void) {
  void * result;
  pthread_join (_thread, &result);
}


pthread_t ThreadSelf (void) {
  return pthread_self ();
}


void Thread::cancel (void) {
  pthread_cancel (_thread);
}
