/* -*- C++ -*- */
/*
  fthread.h
  ------------------------------------------------------------------------
  ------------------------------------------------------------------------
  @(#) $Id: fthread.h,v 1.14 1998/08/04 20:59:22 emery Exp $
  ------------------------------------------------------------------------
  AUTHOR/CONTACT:
 
  Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
  Systems Analyst                 @           <mailto:emery@cs.utexas.edu>
  Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
  Department of Computer Sciences |             <http://www.cs.utexas.edu>
  University of Texas at Austin   |                <http://www.utexas.edu>
  ========================================================================
*/


#ifndef _FTHREAD_H_
#define _FTHREAD_H_

#include <pthread.h>


class Thread {

public:

  Thread ()
    : _thread (0)
  {
    pthread_attr_init (&_attr);
  }

  ~Thread () {
    pthread_attr_destroy (&_attr);
  }

  virtual void start (void (*proc)(void *),
		      void * arg);

  void join (void);
  void cancel (void);

  operator pthread_t (void) {
    return _thread;
  }

protected:

  pthread_t _thread;
  pthread_attr_t _attr;

};


class BoundThread : public Thread {
public:
  void start (void (*proc)(void *),
	      void * arg);
};


extern pthread_t ThreadSelf (void);

#endif
