/*
  header.H
  ------------------------------------------------------------------------
  Includes and defines used by all CODE classes.
  ------------------------------------------------------------------------
  @(#) $Id: header.H,v 1.16 1998/11/06 17:13:40 emery Exp $
  ------------------------------------------------------------------------
  AUTHOR/CONTACT:
 
  Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
  Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
  Department of Computer Sciences |             <http://www.cs.utexas.edu>
  University of Texas at Austin   |                <http://www.utexas.edu>
  ========================================================================
*/

#ifndef _HEADER_H_
#define _HEADER_H_

#include <pthread.h>
#include <config.h>

#include <stdio.h>
#include <iostream.h>
#include <stdlib.h>

#include <sys/times.h>
#include <time.h>

#include "mybool.h"
#include "fthread.h"
#include "fsynch.h"


#ifndef PAD_BYTES
#define PAD_BYTES 64	// The size of a cache line.
#endif
#ifndef PAD_DBL
#define PAD_DBL (PAD_BYTES/sizeof(double))
#endif


const void * const INVALID_POINTER = (void *) 0xDeadBeef;  // Written into memory which should never be referenced.

const int _c2_PARENT = 0;	// Used in _c2_GetAddr to lookup a node's parent.

// Message types.
enum _c2_MessageType { TRANSMIT = 1,	// send all data to another processor
		       RECEIVE,		// receive data from another processor.
		       LOCAL,  		// a copy on this processor.
		       TRANSMIT_FROM_THIEF = 5,	// send all but reader-access shared vars.
		       RECEIVE_FROM_THIEF = 6 };	// receive all but reader-access shared vars.

// Object types
enum _c2_ObjectType { _c2_UCNODE = 1,
		      _c2_NSRELNODE,
		      _c2_CALLNODE };

// NSRel requests
enum _c2_RequestType { _c2_READER = 4,	// I want read-only access.
		       _c2_WRITER };	// I want read-write access.


// Common data for all UC nodes, used by task manager.

enum _c2_ValueType {
    _c2_IsAChar, _c2_IsAnInt, _c2_IsADouble, _c2_IsAStructPtr, _c2_IsAnArrayPtr
};


/*
 * Provide the infrastructure for allowing object name lookup (for debugging,
 * etc.).
 */

const int MAX_NAME_LENGTH = 30;

class _c2_NameTable {
public:
  int UID;
  char Name[MAX_NAME_LENGTH];
};


class _c2_Value {
public:
    enum _c2_ValueType type;
    union {
	char c;
	int i;
	double d;
	void *structure;
	void *array;
    } u;

#ifdef _C2_DBGR_
    _c2_FpList fplist;
    _c2_Cmd cmd;
#endif
};



/*
 * Debugging routines (assertions and the like). Use WHEN for things like print
 * statements. ENSURE is the same as ASSERT. ASSERTMSG will print an
 * explanatory message after the assertion.
 * 
 */

#ifndef NDEBUG
#define WHEN(cond,stmts) if (cond) {stmts;}
#define IFDEBUG(stmts) {stmts;}
#define ASSERT(cond) \
    if (!(cond)) \
      {  \
        fprintf(stderr, "Assertion failed: %s line %d file %s\n", \
                #cond, __LINE__, __FILE__); \
        fflush(stderr); \
	abort(); \
      };

#define ENSURE(cond) ASSERT(cond)
#define ASSERTMSG(cond, msg) \
    if (!(cond)) \
      {  \
        fprintf(stderr, "Assertion failed: %s line %d file %s\n", \
                #cond, __LINE__, __FILE__); \
        fprintf(stderr, "%s\n", msg); \
        fflush(stderr); \
	abort(); \
      };

#define MESSAGE(msg) \
        fprintf(stderr, "Alert: line %d file %s\n", \
                __LINE__, __FILE__); \
        fprintf(stderr, "%s\n", msg); \
        fflush(stderr); \
        abort();

#else

#define WHEN(cond,stmts)
#define IFDEBUG(stmts)
#define ENSURE(cond)
#define ASSERT(cond)
#define ASSERTMSG(cond, msg)
#define MESSAGE(msg)
#endif				/* NDEBUG */


#ifndef dynamic_cast
#define dynamic_cast(x,y) ((x) y)
#endif

#ifndef const_cast
#define const_cast(x,y) ((x) y)
#endif

#ifndef __GNUC__
// SUN CC doesn't have the mutable keyword.
#define mutable
#endif


#endif /* _HEADER_H_ */
