//////////////////////////////////////////////////////////////////////////////
// ParDEE - Parallel Dag Execution Engine
// heap.C
// Robert Blumofe
// $Id: heap.C,v 1.5 1998/08/04 21:00:48 emery Exp $
//
// Copyright (c) 1997, Robert Blumofe.  All rights reserved.
// Permission is given to use, copy, and modify this software for any
// non-commercial purpose as long as this copyright notice is not
// removed.  All other uses, including redistribution in whole or in
// part, are forbidden without prior written permission.  This software
// is provided with absolutely no warranty and no support.
//////////////////////////////////////////////////////////////////////////////
#pragma ident "Copyright (c) 1997, Robert Blumofe, $Id: heap.C,v 1.5 1998/08/04 21:00:48 emery Exp $"

// Header files.
#include <assert.h>
#include <stddef.h>
#include "heap.H"

// Assertion that is always enabled.

#include <stdio.h>
#define	alwaysAssert(EX) (void)((EX) || (fprintf(stderr, "Assertion failed: %s (%s, line %d)\n", #EX, __FILE__, __LINE__),0))


// Initialize heap.
void ParHeap::initHeap (void)
{
  // Move remaining heap to free list.
  if (heap) {
    assert ((heapEnd - heap) < (maxSize + nodeSize()));
    if (heapEnd - heap >= nodeSize()) {
      ParHeapNode* c;
      size_t sz = (heapEnd - heap - nodeSize()) / ALIGN;
      assert (sz < freeLists);
      c = (ParHeapNode*)heap;
      c->size = sz;
      _free ((char*)c + nodeSize());
    }
    heap = 0;
  }

  // Allocate new heap.
  heap = (char*) operator new (heapSize);
  alwaysAssert (heap);
  heapEnd = heap + heapSize;

  // Put heap in list.
  ParHeapNode* c = (ParHeapNode*)heap;
  heap += nodeSize();
  c->next = heapList;
  heapList = c;
}

// Constructor.
ParHeap::ParHeap (unsigned int heapsize, unsigned int maxsize)
  : heapSize (((heapsize + ALIGN - 1) / ALIGN) * ALIGN),
    maxSize (((maxsize + ALIGN - 1) / ALIGN) * ALIGN),
    freeLists (maxSize / ALIGN),
    freeList (new ParHeap::pParHeapNode[maxSize / ALIGN]),
    heap (0),
    heapEnd ((char *) 0xDeadBeef),
    heapList ((ParHeapNode *) 0xDeadBeef)
{
  // Check definitions are consistent.
  assert (maxSize + 2 * nodeSize() <= heapSize);

  // Initialize free lists.
  for (int i = 0; i < freeLists; i++)
    freeList[i] = 0;

  // Initialize heap.
  heapList = 0;
  initHeap();
}

// Destructor.
ParHeap::~ParHeap (void)
{
  // Free each allocated heap.
  ParHeapNode* c = heapList;
  while (c) {
    ParHeapNode* cn = c->next;
    delete c;
    c = cn;
  }
}

//////////////////////////////////////////////////////////////////////////////
// $Log: heap.C,v $
// Revision 1.5  1998/08/04 21:00:48  emery
// Nothing, really.
//
// Revision 1.2  1998/03/18 04:54:14  emery
// Yet more contention reduction (it's working!).
//
// Revision 1.1  1998/03/17 17:29:13  emery
// Somewhat more flexible version of Bobby's heap code.
//
// Revision 1.2  1997/12/03 17:46:11  rdb
// Change name to ParHeap.  Get rid of defines.
//
// Revision 1.1.1.1  1997/11/19 00:41:46  rdb
// Create ParDEE from old PCM
//
//////////////////////////////////////////////////////////////////////////////
