/*
  index.C
  ------------------------------------------------------------------------
  Object indices.
  ------------------------------------------------------------------------
  @(#) $Id: index.C,v 1.6 1997/10/24 15:29:31 emery Exp $
  ------------------------------------------------------------------------
  AUTHOR/CONTACT:
 
  Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
  Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
  Department of Computer Sciences |             <http://www.cs.utexas.edu>
  University of Texas at Austin   |                <http://www.utexas.edu>
  ========================================================================
*/

#include <iostream.h>

#include "header.H"
#include "index.H"


// Receive an index from a messenger.
Messenger& operator>>(Messenger&m, Index& v) {
  m >> v._length;
  m.unpack (&v._index[0], v._length);
  return m;
}


// Send an index to a messenger.
Messenger& operator<<(Messenger&m, const Index& v) {
  m << v._length;
  m.pack (&v._index[0], v._length);
  return m;
}


// Equality over indices.
int operator==(const Index& lhs, const Index& rhs) {
  if (lhs._length != rhs._length)
    return 0;
  for (int i = 0; i < lhs._length; ++i)
    if (lhs._index[i] != rhs._index[i])
      return 0;
  return 1;
}


// Comparison on indices.
// An index with fewer indices is "less than" one with more;
// otherwise we do pointwise comparison to do ordering.
int operator<(const Index& lhs, const Index& rhs) {
  if (lhs._length < rhs._length)
    return 1;
  if (lhs._length > rhs._length)
    return 0;
  
  assert (lhs._length == rhs._length);  
  for (int i = 0; i < lhs._length; ++i) {
    if (lhs._index[i] < rhs._index[i])
      return 1;
    if (lhs._index[i] > rhs._index[i])
      return 0;
  }
  assert (lhs == rhs);
  return 0;
}


// Printing of indices.
ostream& operator<<(ostream& os,
		    const Index& index)
{
  for (int i = 0; i < index._length; ++i) {
    os << "[" << index._index[i] << "]";
  }
  return os;
}
