/*
  index.H
  ------------------------------------------------------------------------
  Object indices.
  ------------------------------------------------------------------------
  @(#) $Id: index.H,v 1.10 1998/11/06 06:25:05 emery Exp $
  ------------------------------------------------------------------------
  AUTHOR/CONTACT:
 
  Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
  Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
  Department of Computer Sciences |             <http://www.cs.utexas.edu>
  University of Texas at Austin   |                <http://www.utexas.edu>
  ========================================================================
*/


#ifndef _INDEX_H_
#define _INDEX_H_

#include <assert.h>

#include "header.H"
#include "messenger.H"


// An Index is an array of 0..MAXINDICES integers.
// These identify replicated instances of objects.

class Index {

  // Receive an index from a messenger.
  friend Messenger& operator>>(Messenger&m, Index& v);

  // Send an index to a messenger.
  friend Messenger& operator<<(Messenger&m, const Index& v);

  // Equality over indices.
  friend int operator==(const Index& lhs, const Index& rhs);

  // Comparison on indices.
  // An index with fewer indices is "less than" one with more;
  // otherwise we do pointwise comparison to do ordering.
  friend int operator<(const Index& lhs, const Index& rhs);

  // Printing of indices.
  friend ostream& operator<<(ostream&, const Index&);


public:

  Index (void)
    : _length (0)
    {}

  Index (int indices[],
	     int numindices)
    : _length (numindices)
    {
      for (int i = 0; i < _length; i++) {
	_index[i] = indices[i];
      }
    }

  ~Index (void) { }

  enum { MAXINDICES = 7 };	// The maximum number of indices allowed.


  const int length (void) const { return _length; }
  int& length (void) { return _length; }

  const int operator[] (const int index) const {
    assert (index >= 0);
    assert (index < MAXINDICES);
    return _index[index];
  }

  int& operator[] (const int index) {
    assert (index >= 0);
    assert (index < MAXINDICES);
    return _index[index];
  }


private:

  int _length;
  int _index[MAXINDICES];
};


#endif /* _INDEX_H_ */
