/*
  mybool.h
  ------------------------------------------------------------------------
  Define a bool enum if needed.
  ------------------------------------------------------------------------
  @(#) $Id: mybool.h,v 1.6 1998/08/04 20:57:30 emery Exp $
  ------------------------------------------------------------------------
  AUTHOR/CONTACT:
 
  Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
  Systems Analyst                 @           <mailto:emery@cs.utexas.edu>
  Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
  Department of Computer Sciences |             <http://www.cs.utexas.edu>
  University of Texas at Austin   |                <http://www.utexas.edu>
  ========================================================================
*/

#ifndef _MYBOOL_H_
#define _MYBOOL_H_

# include <config.h>

#if defined(__GNUC__)
#  ifndef TRUE
#    define TRUE true
#  endif

#  ifndef FALSE
#    define FALSE false
#  endif

#else

# if defined(__STL_YVALS_H)
#  include <yvals.h>
# else
#  if ! defined(__STL_BOOL_KEYWORD)
#   if defined (__STL_RESERVED_BOOL_KEYWORD)
#    define bool int
#    define true 1
#    define false 0
#   else
     typedef int bool;
#    define true 1
#    define false 0
#   endif
#  endif /* __STL_BOOL_KEYWORD */
# endif

#if ! defined(FALSE) && ! defined(TRUE)
enum { FALSE = 0, TRUE = 1 };
#endif

#endif

#endif /* _BOOL_H_ */
