/*
  nodedeque.C
  ------------------------------------------------------------------------
  A deque of computation nodes, with some extra functionality.
  ------------------------------------------------------------------------
  @(#) $Id: nodedeque.C,v 1.5 1998/03/17 00:57:20 emery Exp $
  ------------------------------------------------------------------------
  AUTHOR/CONTACT:
 
  Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
  Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
  Department of Computer Sciences |             <http://www.cs.utexas.edu>
  University of Texas at Austin   |                <http://www.utexas.edu>
  ========================================================================
*/


#include <assert.h>


#include "nodedeque.H"
#include "node.H"


ostream& operator<<(ostream& os,
		    NodeDeque& node)
{
  Protect<Mutex> m (node._lock);

  os << "[";
  deq<CompNode *>::iterator i;

  for (i = node._deque.begin(); i != node._deque.end(); ++i) {
    os << *(*i) << " ";
  }

  os << "]" << endl;
  return os;
}


CompNode * NodeDeque::PopFront (void) {
  Protect<Mutex> m (_lock);
  if (_deque.empty()) {
    return NULL;
  } else {
    CompNode * n = _deque.front();
    assert (n);
    n->PopFront (_deque);
    return n;
  }
}


CompNode * NodeDeque::PopBack (void) {
  Protect<Mutex> m (_lock);
  if (_deque.empty()) {
    return NULL;
  } else {
    CompNode * n = _deque.back();
    assert (n);
    n->PopBack (_deque);
    return n;
  }
}


void NodeDeque::PushFront (CompNode * n) {
  Protect<Mutex> m (_lock);
  n->PushFront (_deque);
  // _deque.push_front (n);
}


void NodeDeque::PushBack (CompNode * n) {
  Protect<Mutex> m (_lock);
  n->PushBack (_deque);
  // _deque.push_back (n);
}
