/*
  nsrel.C
  ------------------------------------------------------------------------
  Name-sharing relation (shared variable) implementation.
  ------------------------------------------------------------------------
  @(#) $Id: nsrel.C,v 1.19 1998/03/24 03:37:22 emery Exp $
  ------------------------------------------------------------------------
  AUTHOR/CONTACT:
 
  Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
  Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
  Department of Computer Sciences |             <http://www.cs.utexas.edu>
  University of Texas at Austin   |                <http://www.utexas.edu>
  ========================================================================
*/

#include <assert.h>
#include <stdio.h>

#include "machine.H"
#include "sermach.H"
#include "node.H"
#include "nsrel.H"


int NameSharingRelation::Processor (void) {
  Guard m (_lock);
  if (_Processor != -1) {
    // Processor has been initialized.
    return _Processor;
  } else {
    if (GetMachine().GetNumProcessors() == 1) {
      _Processor = 0;
    } else {
      _Processor = MyGraph()->Processor();
    }
    return _Processor;
  }
}
