/*
  nsrel.H
  ------------------------------------------------------------------------
  Name-sharing relation (shared variable) interface.
  ------------------------------------------------------------------------
  @(#) $Id: nsrel.H,v 1.18 1998/11/06 05:17:23 emery Exp $
  ------------------------------------------------------------------------
  AUTHOR/CONTACT:
 
  Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
  Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
  Department of Computer Sciences |             <http://www.cs.utexas.edu>
  University of Texas at Austin   |                <http://www.utexas.edu>
  ========================================================================
*/

#ifndef _NSREL_H_
#define _NSREL_H_

#include "atomic.H"
#include "codeobject.H"
#include "header.H"
#include "graph.H"
#include "nslocks.H"
#include "sharedvariable.H"


class Messenger;  // forward declaration


class NameSharingRelation : public CodeObject {
public:

  NameSharingRelation (int uid,
		 Index * index,
		 Graph * graph,
		 CodeDataBase * localdata,
		 void (*init) (NameSharingRelation *),
		 SerialMachine * machine)
    : CodeObject(uid, index, localdata, graph, machine, CodeObject::NSREL),
      _Crepped	(graph->GetCrepsToGo() == 0),
      _InitProc	(init)
  {
    ASSERT (index != NULL);

    if (_Crepped)
      if (_InitProc != NULL)
	_InitProc (this);
  }

  ~NameSharingRelation (void) { }

  inline void * operator new (size_t sz, SerialMachine * sm);
  void * operator new (size_t sz) { return (void *) ::new char[sz]; }

  void operator delete (void *) {}

  void Initialize (void) {
    Guard m (_lock);
    if (!_Crepped) {
      _InitProc (this);
      _Crepped = TRUE;
    }
  }

  int Processor (void);

  //// The following routine is provided
  //// by the CODE backend.

  SharedVariableInfo& GetSharedVarInfo (int UID);

  static void Copy (int NSRelUID, int UID, void **LocalAddr, int direction, Messenger& m);

private:

  bool		_Crepped;
  
  void (*_InitProc) (NameSharingRelation *);

};


inline void * NameSharingRelation::operator new (size_t sz, SerialMachine * sm)
{
  assert (sm);
  return sm->alloc (sz);
}


#endif /* _NSREL_H_ */
