#ifndef _PAD_H_
#define _PAD_H_

#ifndef PAD_BYTES
#define PAD_BYTES 64	// The size of a cache line.
#endif
#ifndef PAD_DBL
#define PAD_DBL (PAD_BYTES/sizeof(double))
#endif


// The pad class just adds a cache line
// pad to the T class, semi-transparently.

// This is useful in dealing with arrays of items
// that we want separated so we don't get false sharing.

template <class T>
class padclass : public T {
public:
  operator T& (void) { return *this; }
  T& operator= (const T& t) { return (*this = t); }
private:
  double	_pad[PAD_DBL];
};


// Pad for non-class types (i.e., void *).

template <class T>
class pad {
public:
  operator T& (void) { return (T&) _self; }
  T& operator= (const T& t) { _self = t; return _self; }
private:
  T	_self;
  double	_pad[PAD_DBL];
};

#endif // _PAD_H_
