/*
  parms.H
  ------------------------------------------------------------------------
  Parameters for the CODE runtime system.
  ------------------------------------------------------------------------
  @(#) $Id: parms.H,v 1.9 1999/03/24 21:16:11 emery Exp $
  ------------------------------------------------------------------------
  AUTHOR/CONTACT:
 
  Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
  Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
  Department of Computer Sciences |             <http://www.cs.utexas.edu>
  University of Texas at Austin   |                <http://www.utexas.edu>
  ========================================================================
*/


#ifndef _PARMS_H_
#define _PARMS_H_


#define ALLOW_REMOTE_WORK_STEALING 1  // 1 = default.
#define DENY_EXECUTION_OF_NONLOCAL_NODES 1
#define DEBUG_PRINT 0

// Processor-mapping algorithms:
// exactly one of the below must be set to 1.

#define ONE_PROCESSOR_PLACEMENT 0	// = map to processor 0.
#define PER_GRAPH_PLACEMENT 0		// = map to graph.
#define MAP_ACROSS_ALL 0		// = old-style placement (map node).
#define MAP_NON_SHARED_ACROSS_ALL 1 	// Default (non-statics can be anywhere).

#if (ONE_PROCESSOR_PLACEMENT + PER_GRAPH_PLACEMENT + MAP_ACROSS_ALL + MAP_NON_SHARED_ACROSS_ALL) != 1
#error "Exactly one of the above defines must be 1."
#endif


// Should we map non-statics to this processor?

#if !(ALLOW_REMOTE_WORK_STEALING)
#define MAP_NONSTATIC_LOCALLY 0
#else
#define MAP_NONSTATIC_LOCALLY 1 // 1 = Default.
#endif

#define THREAD_SAFE_MPI 0

#endif // _PARMS_H_
