/*
  path.H
  ------------------------------------------------------------------------
  CODE object pathname class.
  A pathname has an integer value (its "sum") and a string value.
  The string structure is given by the following regular expression:
    " UID (/ UID ( [ INDEX ] )* )* ".
  The sum equals the sum of all UID's and INDEX values.
  ------------------------------------------------------------------------
  @(#) $Id: path.H,v 1.12 1998/11/06 06:36:20 emery Exp $
  ------------------------------------------------------------------------
  AUTHOR/CONTACT:
 
  Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
  Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
  Department of Computer Sciences |             <http://www.cs.utexas.edu>
  University of Texas at Austin   |                <http://www.utexas.edu>
  ========================================================================
*/


#ifndef _PATHNAME_H_
#define _PATHNAME_H_

#include "header.H"
#include "unique.H"

class CodeObject; // forward declaration
class SerialMachine; // forward declaration

// A pathname has an integer value (its "sum")
// and a string value.

// The string structure is given by the following regular expression:
//    " UID (/ UID ( [ INDEX ] )* )* ".
// The sum equals the sum of all UID's and INDEX values.

class Pathname : public Unique {
  friend ostream& operator<<(ostream&, const Pathname&);
  friend int operator==(const Pathname&, const Pathname&);
public:

  enum { PATH_ID_LENGTH = 255 }; // The maximum length of a path.


  // Initialize the path from a string.
  Pathname (const char * text);

  // Initialize the path from an object.
  Pathname (const CodeObject& obj);

  ~Pathname (void);

  // Return a string representation of the path.
  const char * str (void) const;

  // Turn a path into a CodeObject.
  CodeObject * decode (SerialMachine *) const;

  // Map the path to an integer from 0 to nprocs.
  int map (int nprocs) const;


private:
  // Return the sum of the path.
  int sum (void) const;

  int _sum;
  char _buf[PATH_ID_LENGTH]; // The text buffer.
};

#endif /* _PATHNAME_H_ */
