/*
  port.C
  ------------------------------------------------------------------------
  Input port management.
  ------------------------------------------------------------------------
  @(#) $Id: port.C,v 1.15 1998/03/24 03:37:23 emery Exp $
  ------------------------------------------------------------------------
  AUTHOR/CONTACT:
 
  Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
  Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
  Department of Computer Sciences |             <http://www.cs.utexas.edu>
  University of Texas at Austin   |                <http://www.utexas.edu>
  ========================================================================
*/

#define _PTHREADS

#include "deq.h"

#include "port.H"
#include "sermach.H"


// A function object used for finding a matching entry.
class PortIndexEquals {
public:

  PortIndexEquals (Index portindex)
    : _portindex (portindex)
  {}

  int operator() (Port::Item& p)
  {
    return (p.portindex == _portindex);
  }

private:
  Index	_portindex;
};


Port::Port (SerialMachine * sm)
  : _machine (sm)
{
  for (int i = 0; i < MAX_INDICES; i++) {
    _pq[i] = new (_machine) deq<Item>(_machine);
  }
}


void Port::Add (const Index& portindex,
		const _c2_Value& value)
{
  int n = hashindex(portindex);
  Guard m (_lock[n]);
  Item newitem (portindex, value);
  _pq[n]->push_back (newitem);
}


void Port::Add (const Index& portindex,
		const _c2_Value& value,
		SerialMachine * sm)
{
  int n = hashindex(portindex);
  Guard m (_lock[n]);
  Item newitem (portindex, value);
  _pq[n]->push_back (newitem, sm);
}


int Port::Find (Index& portindex)
{
  int n = hashindex (portindex);
  Guard m (const_cast(Port *, this)->_lock[n]);

  deq<Item>::iterator i;

  int j = _pq[n]->size();

  for (i = _pq[n]->begin ();
       i != _pq[n]->end ();
       ++i, --j) {
    if (portindex == (*i).portindex)
      break;
    assert (j >= 0);
  }

  if (i != _pq[n]->end ()) {
    return 1;
  }
  return 0;
}


int Port::Remove (Index& portindex,
		  _c2_Value& value)
{
  int n = hashindex (portindex);
  Guard m (_lock[n]);
  deq<Item>::iterator i;
  // Look for a matching port index.

  for (i = _pq[n]->begin ();
       i != _pq[n]->end ();
       ++i) {
    if (portindex == (*i).portindex)
      break;
  }

  if (i != _pq[n]->end ()) {
    value = (*i).value;
    _pq[n]->erase (i);
    return 1;
  }
  // No match found.
  return 0;
}
