/*
  port.H
  ------------------------------------------------------------------------
  Input port management.
  ------------------------------------------------------------------------
  @(#) $Id: port.H,v 1.18 1998/11/06 20:33:01 emery Exp $
  ------------------------------------------------------------------------
  AUTHOR/CONTACT:
 
  Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
  Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
  Department of Computer Sciences |             <http://www.cs.utexas.edu>
  University of Texas at Austin   |                <http://www.utexas.edu>
  ========================================================================
*/

#ifndef _PORT_H_
#define _PORT_H_

#include <iostream.h>

#include "header.H"
#include "atomic.H"
#include "unique.H"
#include "index.H"
#include "heap.H"
#include "machine.H"
#include "sermach.H"
#include "pad.h"

#define _PTHREADS

#include "deq.h"
#include "heap.H"


class Port : public Unique {
public:

  enum { MAX_INDICES = 7 };

  // An Item is a tuple of (port index, value).
  class Item {
  public:
    Item (void) {}

    Item (Index p, _c2_Value v)
      : portindex(p),
	value(v) { }
    
    ~Item (void) { }
    
    Index portindex;
    _c2_Value value;
  };

public:

  Port (SerialMachine * sm);

  ~Port (void) {
    // delete [] _pq;
  }

  inline void * operator new (size_t sz, SerialMachine * sm);
  void * operator new (size_t sz) { return (void *) ::new char[sz]; }
  void operator delete (void *) {}

  // Add a value to this port[portindex].
  void Add (const Index& portindex,
	    const _c2_Value& value);

  // Add a value to this port[portindex].
  void Add (const Index& portindex,
	    const _c2_Value& value,
	    SerialMachine * sm);

  // See if any value is on this port[portindex].
  int Find (Index& portindex);
  
  // Return (and remove) a value from this port[portindex].
  int Remove (Index& portindex, _c2_Value& value);
  
private:

  int hashindex (const Index& portindex) {
    int sum = 0;
    for (int i = 0; i < portindex.length(); ++i) {
      sum += portindex[i];
    }
    return sum % MAX_INDICES;
  }

  SerialMachine *	_machine;
  deq<Item> *		_pq[MAX_INDICES];
  MutexRec		_lock[MAX_INDICES];
};


inline void * Port::operator new (size_t sz, SerialMachine * sm)
{
  assert (sm);
  return sm->alloc (sz);
}


typedef Port *		_c2_SeqVarQ;

#endif /* _PORT_H_ */
