/*
  readyq.H
  ------------------------------------------------------------------------
  A queue (ok, a deque) of computation nodes ready for execution.
  ------------------------------------------------------------------------
  @(#) $Id: readyq.H,v 1.23 1998/03/18 04:54:21 emery Exp $
  ------------------------------------------------------------------------
  AUTHOR/CONTACT:
 
  Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
  Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
  Department of Computer Sciences |             <http://www.cs.utexas.edu>
  University of Texas at Austin   |                <http://www.utexas.edu>
  ========================================================================
*/


#ifndef _READYQ_H_
#define _READYQ_H_

#include "header.H"
#include "atomic.H"
#include "unique.H"
#include "nodedeque.H"

class SerialMachine; // forward declaration
class CompNode; // forward declaration

class ReadyDeque : public Unique {
public:

  ReadyDeque (SerialMachine * sermach)
    : _Stop (FALSE)
    {
      typedef NodeDeque * pNodeDeque;
      rq = new pNodeDeque[2];
      rq[0] = new NodeDeque (sermach);
      rq[1] = new NodeDeque (sermach);
    }

  ~ReadyDeque () { delete [] rq; }


  // Pop a node off of the queue.
  // Returns FALSE if the queue is empty.
  bool TryPopNode (CompNode *& node);

  // Pop a node off of the queue for a thief.
  // Returns FALSE if no items on the queue
  // were available for theft.
  bool TryStealNode (CompNode *& node);

  // Pop a node off of the queue for a thief.
  // Returns FALSE if no items on the queue
  // were available for theft.
  bool TryLocalStealNode (CompNode *& node);

  // Clear the entire ready queue.
  void Clear (void);
 
  // Disallow future reads from ready queue.
  void Stop (void);

  // Put a node on the queue.
  // This should only be done from within CODE_Machine::Schedule.
  void Enqueue (CompNode *);

  // Put a STOLEN node on the queue.
  // This should only be done from within CODE_Machine::Schedule.
  void EnqueueStolen (CompNode *);

#if 0
  // Wait for something to be added to the queue.
  void Wait (void) {
    Protect<Mutex> m (_lock);
    if (!_Stop) {
      if (rq[LIGHT_QUEUE].Empty() && rq[HEAVY_QUEUE].Empty()) {
	_lock.wait (_cond);
      }
    }
  }
#endif

private:

  bool Stopped (void)
  {
    Protect<Mutex> m (_lock);
    return _Stop;
  }

  enum { LOCAL = 0,
	 LOCAL_THIEF,
	 REMOTE_THIEF };

  CompNode * Pop (int Thief);

  // Auxiliary routine used by *StealNode and *PopNode.
  // node = removed node if any (return val = TRUE).

  bool RemoveNode (CompNode *& node,
		  int Thief);
  
  enum { LIGHT_QUEUE = 0,		// The queue for stateless nodes,
	 HEAVY_QUEUE = 1};		// and for static nodes.

  NodeDeque **		rq;		// The deques which comprise the ready queue.
  bool			_Stop;		// If true, nothing else can be added to the deque.
  // Condition		_cond;		// A condition variable to allow waiting for
					// something to be added.

  double _pad[PAD_DBL]; // padding to avoid false sharing.

  mutable Mutex		_lock;		// The lock for the data structure.
};


#endif /* _READYQ_H_ */
