/*
  sermach.H
  ------------------------------------------------------------------------
  A serial CODE machine.
  ------------------------------------------------------------------------
  @(#) $Id: sermach.H,v 1.3 1998/11/06 05:06:21 emery Exp $
  ------------------------------------------------------------------------
  AUTHOR/CONTACT:
 
  Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
  Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
  Department of Computer Sciences |             <http://www.cs.utexas.edu>
  University of Texas at Austin   |                <http://www.utexas.edu>
  ========================================================================
*/


#ifndef _SERMACH_H_
#define _SERMACH_H_

#include "header.H"
#include "mybool.h"
#include "messenger.H"
#include "atomic.H"
#include "timer.H"
#include "unique.H"


// forward declarations
class CompNode;
class ReadyDeque;
class ParHeap;
class CODE_Machine;

void SerialMachine_Worker (void * m);


// The CODE execution engine.

class SerialMachine : public Unique {
public:

  SerialMachine (CODE_Machine * parmach,
		 int numworkers,
		 int numprocessors,
		 int whichprocessor,
		 int whichworker,
		 Messenger* messenger,
		 bool timenodes = false);	// Do we time the execution of every node?

  ~SerialMachine (void);

  // get the number of threads.
  const int GetNumWorkers (void) const { return _NumWorkers; }

  // get the number of processors (= machines).
  const int GetNumProcessors (void) const { return _NumProcessors; }

  // which processor am I?
  const int WhichProcessor (void) const { return _WhichProcessor; }

  // which worker am I? (0 to GetNumWorkers() - 1)
  const int WhichWorker (void) const { return _WhichWorker; }

  // Execute a node.
  void Execute (CompNode * node);

  // Schedule a particular node for execution.
  void Schedule (CompNode * node, int stolen = FALSE);

  // Stop this worker.
  void Stop (void) { _Stopped = TRUE; }

  // Stop this worker (called when a Stop node executes).
  void LocalStop (void);

  // A worker (one per thread).
  void Worker (CompNode * initnode);

  // Heap access.
  void * alloc (size_t sz);
  void free (void * ptr);
  ParHeap * GetHeap (void) { return _Heap; }

  // ACCESSORS.

  ReadyDeque&	GetReadyQ (void) { return *_ReadyQ; }
  const ReadyDeque&	GetReadyQ (void) const { return *_ReadyQ; }

  // Return a pointer to my messenger.
  Messenger*	GetMessenger (void) { return _Messenger; }

  CODE_Machine& GetParallelMachine (void) { return *_ParallelMachine; }

  // An internal random number generator.
  u_long lrand16 (void);

private:

  // Return whether or not we should collect times for all nodes.
  bool TimeNodes (void) const { return _TimeNodes; }
  
  // True iff still running.
  bool	Running (void) { return !_Stopped; }

  //
  // Work-stealing routines.
  //

  // Try to steal some work.
  void AttemptSteal (void);


  mutable MutexRec _lock;	// The lock for these data structures.

  CODE_Machine * _ParallelMachine;

  const int	_NumWorkers;	// Number of workers (= number of CPUs).
  const int	_WhichWorker;

  u_long	_RandVal;	// Random values.
  Messenger *	_Messenger;	// The messenger used to handle intra-processor msgs.
  ParHeap *	_Heap;		// This machine's heap.

  ReadyDeque *	_ReadyQ;	// One ready queue per worker.

  bool		_TimeNodes;	// If true, we collect timings per node.

  const int	_WhichProcessor;	// Which processor are we?
  const int	_NumProcessors;		// How many processors are there?
  volatile int		_Stopped;
  Timer		_Runtime;
};


#endif // _SERMACH_H_ */
