/*
  sharedvariable.C
  ------------------------------------------------------------------------
  The extra information required by shared variables.
  ------------------------------------------------------------------------
  @(#) $Id: sharedvariable.C,v 1.4 1998/05/28 22:51:30 emery Exp $
  ------------------------------------------------------------------------
  AUTHOR/CONTACT:
 
  Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
  Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
  Department of Computer Sciences |             <http://www.cs.utexas.edu>
  University of Texas at Austin   |                <http://www.utexas.edu>
  ========================================================================
*/


#include "atomic.H"
#include "node.H"
#include "sharedvariable.H"

#define _PTHREADS
#define times times_
#include <deque.h> // STL
#include <function.h> // STL
#include <set.h> // STL
#undef times

#define CLASS_INVARIANT \
  assert (_ActiveReaders >= 0 && _ActiveWriters >= 0 && _ActiveWriters <= 1); \
  assert (((_ActiveReaders > 0) && (_ActiveWriters == 0)) || \
	  ((_ActiveReaders == 0) && (_ActiveWriters == 1)) || \
	  ((_ActiveReaders == 0) && (_ActiveWriters == 0)))


// Remove all the nodes from the deque and enqueue them.
void EnqueueAll (set<CompNode *, less<CompNode *> >& dq)
{
  set<CompNode *, less<CompNode *> >::iterator i;
  for (i = dq.begin ();
       i != dq.end ();
       ++i) {
    assert ((*i) != NULL);
    (*i)->Enqueue ();
  }
  dq.erase (dq.begin(), dq.end());
}


int SharedVariableInfo::acquire (CompNode * node,
				 _c2_RequestType reqtype)
{
  Guard m (_SharedVarLock);

  int Acquired = 0;

  CLASS_INVARIANT;

  // There are three cases: there are active readers, writers, or neither.

  if (_ActiveReaders > 0) {		// Active readers
    if (reqtype == _c2_READER) {
      // Allow another reader iff there are no writers waiting.
      if (_WaitingWriters.empty ()) {
	++_ActiveReaders;
	Acquired = 1;
      } else {
	_WaitingReaders.insert (node);
      }
    } else {
      _WaitingWriters.insert (node);
    }

  } else if (_ActiveWriters > 0) {	// An active writer.

    assert (_ActiveWriters == 1);

    if (reqtype == _c2_READER) {
      _WaitingReaders.insert (node);
    } else {
      _WaitingWriters.insert (node);
    }

  } else {			// No current readers or writers
    if (reqtype == _c2_READER) {
      ++_ActiveReaders;
    } else {
      ++_ActiveWriters;
    }
    Acquired = 1;
  }
  
  CLASS_INVARIANT;

  return Acquired;
}

				
void SharedVariableInfo::release (_c2_RequestType reqtype)
{
  Guard m (_SharedVarLock);

  CLASS_INVARIANT;

  if (reqtype == _c2_READER) {

    assert (_ActiveReaders > 0);
    --_ActiveReaders;
    if (_ActiveReaders == 0) {
      EnqueueAll (_WaitingWriters);
    }
    
  } else {			// Write request
    
    assert (_ActiveWriters == 1);
    _ActiveWriters = 0;
    if (!(_WaitingWriters.empty())) {
      EnqueueAll (_WaitingWriters);
    } else {
      EnqueueAll (_WaitingReaders);
    }
  }

  CLASS_INVARIANT;
}
