/*
  sharedvariable.H
  ------------------------------------------------------------------------
  The extra information required by shared variables.
  ------------------------------------------------------------------------
  @(#) $Id: sharedvariable.H,v 1.3 1998/03/17 00:57:30 emery Exp $
  ------------------------------------------------------------------------
  AUTHOR/CONTACT:
 
  Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
  Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
  Department of Computer Sciences |             <http://www.cs.utexas.edu>
  University of Texas at Austin   |                <http://www.utexas.edu>
  ========================================================================
*/


#ifndef _SHAREDVARIABLE_H_
#define _SHAREDVARIABLE_H_

#include "atomic.H"
#include "header.H"
#include "unique.H"


class CompNode;

#define _PTHREADS

#define times times_
#include <deque.h> // STL
#include <function.h> // STL
#include <set.h> // STL
#undef times


class SharedVariableInfo : public Unique {

public:

  SharedVariableInfo (void)
    : _SharedVarLock ("SharedVariableInfo::Lock"),
      _Initialized (0),
      _ActiveReaders (0),
      _ActiveWriters (1),	// This initially "locks" the shared variable.
      _Address (NULL),
      _UID (-1)
  {}

  ~SharedVariableInfo (void) {}

  void initialize (void) {
    // Once the name-sharing relation has been initialized,
    // set active writers to zero (this "unlocks" the shared variable).
    assert (!_Initialized);
    assert (_ActiveWriters == 1 && _ActiveReaders == 0);
    _ActiveWriters = 0;
    _Initialized = 1;
  }

  // Attempt to acquire a lock on this shared variable.
  // Returns 1 iff the lock was acquired.
  // Otherwise, the node will be placed on a wait queue.
  int acquire (CompNode * node,
	       _c2_RequestType reqtype);

  // Release a lock, held by a reader or writer (specified in reqtype).
  void release (_c2_RequestType reqtype);


  // Mutators and accessors.

  void SetUID (int uid) { _UID = uid; }

  MutexRec& GetLock (void) { return _SharedVarLock; }
  void **& GetAddress (void) { return _Address; }
  int GetUID (void) { return _UID; }

private:
  
  int			_Initialized;

  void **		_Address;		// The shared variable's address.
  int			_UID;			// The shared variable's UID.
  int 			_ActiveReaders;		// The number of current readers.
  set<CompNode *, less<CompNode *> >	_WaitingReaders;	// The nodes waiting for read-only access to this shared variable.
  int 			_ActiveWriters;		// The number of current writers.
  set<CompNode *, less<CompNode *> >	_WaitingWriters;	// The nodes waiting for read-write access to this shared variable.

  double _pad[PAD_DBL]; // padding to avoid false sharing.

  MutexRec 		_SharedVarLock;		// A lock for the shared variable.

};


#endif // _SHAREDVARIABLE_H_
